/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmonBase;
import com.pixelmonmod.pixelmon.client.gui.inventory.SlotInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.widgets.PokeCheckerButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetCharmPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetHeldItemPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.ChangeLurePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ServerSwapPacket;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.LureItem;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.awt.Color;
import java.text.NumberFormat;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;

public class InventoryPixelmon<T extends DisplayEffectsScreen> {
    private T gui;
    private int partyWidth;
    private SlotInventoryPixelmon[] pixelmonSlots;
    private StoragePosition selected;
    private PokeCheckerButton pokeChecker;
    private boolean drawerOut = false;
    private int drawerOffset = 0;
    private int[] lureSlot;
    private int ticksTillClick = 0;

    public InventoryPixelmon(T gui, int partyWidth) {
        this.gui = gui;
        this.pixelmonSlots = new SlotInventoryPixelmon[6];
        this.partyWidth = partyWidth;
    }

    public void initGui() {
        int slotLeft = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 34;
        int slotTop = ((DisplayEffectsScreen)this.gui).field_230709_l_ / 2 + 21;
        this.lureSlot = new int[]{slotLeft - 16 - (this.gui instanceof CreativeScreen ? 1 : 0), slotTop + 20};
        this.pokeChecker = new PokeCheckerButton((Screen)this.gui);
        ((InventoryPixelmonBase)this.gui).getButtonList().add((Widget)this.pokeChecker);
        this.reloadSlots();
    }

    private void reloadSlots() {
        int i;
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            this.pixelmonSlots[i] = null;
        }
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            StoragePosition position = new StoragePosition(-1, i);
            Pokemon pokemon = ClientStorageManager.party.get(i);
            if (pokemon == null) continue;
            int x = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 8;
            int y = ((DisplayEffectsScreen)this.gui).field_230709_l_ / 2 + i * 18 - 75;
            this.pixelmonSlots[i] = new SlotInventoryPixelmon(x, y, position);
        }
    }

    public void render(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        boolean recipeBookVisible;
        boolean bl = recipeBookVisible = this.gui instanceof InventoryScreen && ((InventoryScreen)this.gui).func_194310_f().func_191878_b();
        if (recipeBookVisible) {
            return;
        }
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            if ((!this.pokeChecker.field_230693_o_ || mouseY < this.pokeChecker.field_230691_m_ || mouseY > this.pokeChecker.field_230691_m_ + this.pokeChecker.func_238483_d_()) && slot.getBounds().contains(mouseX, mouseY)) {
                ScreenHelper.drawPokemonHoverInfo(matrix, pokemon, mouseX, mouseY);
                continue;
            }
            if (pokemon.isEgg() || !slot.getHeldItemBounds().contains(mouseX, mouseY) || !this.heldItemQualifies(pokemon) || this.ticksTillClick > 0) continue;
            this.gui.getMinecraft().func_110434_K().func_110577_a(Resources.pixelmonCreativeInventory);
            if (pokemon.getHeldItem().func_190926_b()) continue;
            this.gui.func_230457_a_(matrix, pokemon.getHeldItem(), mouseX, mouseY);
        }
        if (ClientStorageManager.party.getLure() != null) {
            this.gui.getMinecraft().func_175599_af().func_180450_b(ClientStorageManager.party.getLureStack(), this.lureSlot[0], this.lureSlot[1]);
            this.gui.getMinecraft().func_175599_af().func_180453_a(this.gui.getMinecraft().field_71466_p, ClientStorageManager.party.getLureStack(), this.lureSlot[0], this.lureSlot[1], null);
            if (mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16) {
                this.gui.func_230457_a_(matrix, ClientStorageManager.party.getLureStack(), mouseX, mouseY);
            }
        }
        if (this.drawerOut && this.drawerOffset < 42) {
            this.drawerOffset += 3;
            if (this.drawerOffset > 42) {
                this.drawerOffset = 42;
            }
        } else if (!this.drawerOut && this.drawerOffset > 0) {
            this.drawerOffset -= 3;
            if (this.drawerOffset < 0) {
                this.drawerOffset = 0;
            }
        }
    }

    public void drawGuiContainerBackgroundLayer(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.disableLighting();
        RenderSystem.disableFog();
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            slot.setX(((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 8);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, slot.x, slot.y, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), ((InventoryPixelmonBase)this.gui).getZLevel() + 1.0f);
            }
            RenderSystem.disableLighting();
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, slot.x, slot.y, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
            if (!pokemon.isEgg()) {
                if (pokemon.getHeldItem() != ItemStack.field_190927_a) {
                    this.gui.getMinecraft().func_175599_af().func_175042_a(pokemon.getHeldItem(), slot.heldItemX, slot.heldItemY);
                } else {
                    ScreenHelper.drawImageQuad(Resources.heldItem, matrix, slot.heldItemX + 3, slot.heldItemY + 3, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                }
            }
            if (!slot.position.equals(this.selected)) continue;
            ScreenHelper.drawImageQuadUV(Resources.pcResources, matrix, (float)slot.x + 0.5f, (float)slot.y + 0.5f, 15.0f, 15.0f, 0.0f, 29.0f, 29.0f, 29.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        if ((ClientStorageManager.party.getLure() != null || this.gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof LureItem) && mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, matrix, this.lureSlot[0] - 1, this.lureSlot[1] - 1, 18.0f, 18.0f, 0.23046875f, 0.7265625f, 0.30078125f, 0.796875f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        int bX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth;
        int bY = ((DisplayEffectsScreen)this.gui).field_230709_l_ / 2;
        if (this.drawerOffset > 0) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, matrix, bX - 2 - this.drawerOffset, bY - 83, 7 + this.drawerOffset, 166.0f, 0.609375f, 0.0f, (163.0f + (float)this.drawerOffset) / 256.0f, 0.6484375f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
            if (this.drawerOut && mouseX >= bX - 38 && mouseX <= bX - 28 && mouseY >= bY - 18 && mouseY <= bY + 18) {
                ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, matrix, bX - 35, bY - 5, 5.0f, 10.0f, 0.01953125f, 0.671875f, 0.0390625f, 0.7109375f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
            }
            if (this.drawerOffset > 40) {
                EnumMegaItemsUnlocked megaItems;
                EnumFeatureState ovalCharm;
                EnumFeatureState shinyCharm;
                EnumFeatureState expCharm;
                EnumFeatureState catchingCharm;
                EnumFeatureState markCharm = EntityPlayerExtension.getPlayerMarkCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g);
                if (markCharm.isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.markCharmBig, matrix, bX + 17 - this.drawerOffset, bY + 55, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!markCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY + 55, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((catchingCharm = EntityPlayerExtension.getPlayerCatchingCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.catchingCharmBig, matrix, bX + 17 - this.drawerOffset, bY + 32, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!catchingCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY + 32, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((expCharm = EntityPlayerExtension.getPlayerExpCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.expCharmBig, matrix, bX + 17 - this.drawerOffset, bY + 9, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!expCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY + 9, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((shinyCharm = EntityPlayerExtension.getPlayerShinyCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.shinyCharmBig, matrix, bX + 17 - this.drawerOffset, bY - 14, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!shinyCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY - 14, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((ovalCharm = EntityPlayerExtension.getPlayerOvalCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.ovalCharmBig, matrix, bX + 17 - this.drawerOffset, bY - 36, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!ovalCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY - 36, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((megaItems = EntityPlayerExtension.getPlayerMegaItemsUnlocked((PlayerEntity)this.gui.getMinecraft().field_71439_g)).canMega()) {
                    ScreenHelper.drawImageQuad(Resources.keyStoneBig, matrix, bX + 17 - this.drawerOffset, bY - 59, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)this.gui.getMinecraft().field_71439_g).canMega()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY - 59, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if (megaItems.canDynamax()) {
                    ScreenHelper.drawImageQuad(Resources.dynamaxBandBig, matrix, bX + 17 - this.drawerOffset, bY - 81, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!EntityPlayerExtension.getPlayerMegaItem((PlayerEntity)this.gui.getMinecraft().field_71439_g).canDynamax()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, matrix, bX + 17 - this.drawerOffset, bY - 81, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
            }
        } else if (mouseX >= bX - 9 && mouseX <= bX + 1 && mouseY >= bY - 18 && mouseY <= bY + 18) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, matrix, bX - 6, bY - 5, 5.0f, 10.0f, 0.0f, 0.671875f, 0.01953125f, 0.7109375f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        if (this.drawerOffset > 0) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, matrix, bX, bY - 83, 5.0f, 166.0f, 0.1484375f, 0.0f, 0.16796875f, 0.6484375f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        if (ClientData.playerMoney != null) {
            ScreenHelper.drawStringRightAligned(matrix, NumberFormat.getInstance().format(ClientData.playerMoney), ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 44, (float)((DisplayEffectsScreen)this.gui).field_230709_l_ / 2.0f + 66.0f, 0xF0F0F0, false, true);
        }
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    private boolean heldItemQualifies(Pokemon pokemon) {
        ItemStack handStack = this.gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o();
        ItemStack heldStack = pokemon.getHeldItem();
        if (handStack.func_190926_b() && !heldStack.func_190926_b()) {
            return true;
        }
        return !handStack.func_190926_b() && handStack.func_77973_b() instanceof HeldItem;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseX >= (double)this.lureSlot[0] && mouseX <= (double)(this.lureSlot[0] + 16) && mouseY >= (double)this.lureSlot[1] && mouseY <= (double)(this.lureSlot[1] + 16) && this.ticksTillClick <= 0) {
            ItemStack held = this.gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o();
            ItemStack lure = ClientStorageManager.party.getLureStack();
            boolean creative = this.gui.getMinecraft().field_71439_g.func_184812_l_();
            if (held.func_190926_b() && lure.func_190926_b()) {
                return false;
            }
            if (held.func_77973_b() instanceof LureItem) {
                if (lure.func_190926_b()) {
                    ClientStorageManager.party.setLureStack(lure);
                    this.gui.getMinecraft().field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    NetworkHelper.sendToServer(creative ? new ChangeLurePacket(ChangeLurePacket.Change.PUT, held.func_77973_b(), held.func_77952_i()) : new ChangeLurePacket(ChangeLurePacket.Change.PUT));
                } else {
                    this.gui.getMinecraft().field_71439_g.field_71071_by.func_70437_b(lure);
                    ClientStorageManager.party.setLureStack(held);
                    NetworkHelper.sendToServer(creative ? new ChangeLurePacket(ChangeLurePacket.Change.SWAP, held.func_77973_b(), held.func_77952_i()) : new ChangeLurePacket(ChangeLurePacket.Change.SWAP));
                }
            } else if (!lure.func_190926_b() && held.func_190926_b()) {
                this.gui.getMinecraft().field_71439_g.field_71071_by.func_70437_b(lure);
                ClientStorageManager.party.setLureStack(ItemStack.field_190927_a);
                NetworkHelper.sendToServer(new ChangeLurePacket(ChangeLurePacket.Change.TAKE));
            }
            this.ticksTillClick = 10;
            return false;
        }
        if (this.pokeChecker.func_231047_b_(mouseX, mouseY)) {
            if (mouseButton == 0) {
                this.pokeChecker.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            return false;
        }
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            int slotY;
            int slotX;
            Pokemon pokemon;
            SlotInventoryPixelmon slot = this.pixelmonSlots[i];
            StoragePosition position = slot == null ? null : slot.position;
            Pokemon pokemon2 = pokemon = position == null ? null : ClientStorageManager.party.get(position);
            if (slot != null) {
                slotX = slot.x;
                slotY = slot.y;
            } else {
                slotX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 6;
                slotY = ((DisplayEffectsScreen)this.gui).field_230709_l_ / 2 + i * 18 - 75;
            }
            if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16)) {
                if (mouseButton == 1) {
                    this.pokeChecker.setPokemon(ClientStorageManager.party, position, pokemon, (int)mouseX, (int)mouseY);
                } else {
                    this.pokeChecker.setPokemon(null, null, null, (int)mouseX, (int)mouseY);
                }
                if (mouseButton == 0) {
                    if (this.selected == null) {
                        this.selected = position;
                    } else {
                        NetworkHelper.sendToServer(new ServerSwapPacket(this.selected, ClientStorageManager.party.get(this.selected), new StoragePosition(-1, i), pokemon));
                        ClientStorageManager.party.swap(this.selected.order, i);
                        this.selected = null;
                        this.reloadSlots();
                    }
                }
                return false;
            }
            if (this.ticksTillClick > 0 || pokemon == null || pokemon.isEgg() || !this.heldItemQualifies(pokemon) || !slot.getHeldItemBounds().contains(mouseX, mouseY)) continue;
            SetHeldItemPacket packet = new SetHeldItemPacket(position, pokemon.getUUID());
            PlayerInventory inventory = this.gui.getMinecraft().field_71439_g.field_71071_by;
            ItemStack currentItem = inventory.func_70445_o();
            ItemStack oldItem = pokemon.getHeldItem();
            if (this.gui.getMinecraft().field_71439_g.func_184812_l_()) {
                if (!currentItem.func_190926_b()) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    packet.setItem(currentItem.func_77973_b());
                } else {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    packet.setItem(null);
                }
            } else {
                ItemStack playerItem;
                if (oldItem.func_190926_b()) {
                    if (!currentItem.func_190926_b()) {
                        ItemStack singleItem = currentItem.func_77946_l();
                        singleItem.func_190920_e(1);
                        pokemon.setHeldItem(singleItem);
                        if (currentItem.func_190916_E() <= 1) {
                            inventory.func_70437_b(ItemStack.field_190927_a);
                        } else {
                            currentItem.func_190918_g(1);
                        }
                    }
                } else if (currentItem.func_190926_b()) {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    inventory.func_70437_b(oldItem);
                } else if (ItemStack.func_179545_c((ItemStack)oldItem, (ItemStack)currentItem) && ItemStack.func_77970_a((ItemStack)oldItem, (ItemStack)currentItem)) {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    currentItem.func_190917_f(1);
                } else if (currentItem.func_190916_E() <= 1) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    inventory.func_70437_b(oldItem);
                } else {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    currentItem.func_190918_g(1);
                    inventory.func_70441_a(oldItem);
                }
                if (!(playerItem = inventory.func_70445_o()).func_190926_b() && playerItem.func_190916_E() > 64) {
                    playerItem.func_190920_e(64);
                }
            }
            NetworkHelper.sendToServer(packet);
            this.ticksTillClick = 10;
            return false;
        }
        int bX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth;
        int bY = ((DisplayEffectsScreen)this.gui).field_230709_l_ / 2;
        if (this.drawerOut) {
            if (mouseX >= (double)(bX - 38) && mouseX <= (double)(bX - 28) && mouseY >= (double)(bY - 18) && mouseY <= (double)(bY + 18)) {
                this.drawerOut = false;
                return false;
            }
            if (mouseX >= (double)(bX - 25) && mouseX <= (double)(bX - 1)) {
                EnumFeatureState charm;
                if (mouseY > (double)(bY + 55) && mouseY < (double)(bY + 79)) {
                    charm = EntityPlayerExtension.getPlayerMarkCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Mark, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY + 33) && mouseY < (double)(bY + 55)) {
                    charm = EntityPlayerExtension.getPlayerCatchingCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Catching, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY + 9) && mouseY < (double)(bY + 33)) {
                    charm = EntityPlayerExtension.getPlayerExpCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Exp, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 13) && mouseY < (double)(bY + 9)) {
                    charm = EntityPlayerExtension.getPlayerShinyCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Shiny, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 35) && mouseY < (double)(bY - 13)) {
                    charm = EntityPlayerExtension.getPlayerOvalCharm((PlayerEntity)this.gui.getMinecraft().field_71439_g);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Oval, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 58) && mouseY < (double)(bY - 36)) {
                    if (EntityPlayerExtension.getPlayerMegaItemsUnlocked((PlayerEntity)this.gui.getMinecraft().field_71439_g).canMega()) {
                        this.gui.getMinecraft().func_147108_a((Screen)new MegaItemScreen(false));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 79) && mouseY < (double)(bY - 58) && EntityPlayerExtension.getPlayerMegaItemsUnlocked((PlayerEntity)this.gui.getMinecraft().field_71439_g).canDynamax()) {
                    this.gui.getMinecraft().func_147108_a((Screen)new MegaItemScreen(true));
                }
            }
        } else if (mouseX >= (double)(bX - 9) && mouseX <= (double)(bX + 1) && mouseY >= (double)(bY - 18) && mouseY <= (double)(bY + 18)) {
            this.drawerOut = true;
            return false;
        }
        return true;
    }

    public void tick() {
        if (this.ticksTillClick > 0) {
            --this.ticksTillClick;
        }
    }

    public int getSlotClicked(double mouseX, double mouseY) {
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            int slotY;
            int slotX;
            Pokemon pokemon;
            SlotInventoryPixelmon slot = this.pixelmonSlots[i];
            StoragePosition position = slot == null ? null : slot.position;
            Pokemon pokemon2 = pokemon = position == null ? null : ClientStorageManager.party.get(position);
            if (slot != null) {
                slotX = slot.x;
                slotY = slot.y;
            } else {
                slotX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 6;
                slotY = ((DisplayEffectsScreen)this.gui).field_230709_l_ / 2 + i * 18 - 75;
            }
            if (!(mouseX >= (double)slotX) || !(mouseX <= (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY <= (double)(slotY + 16))) continue;
            return i;
        }
        return -1;
    }

    public StoragePosition getSelected() {
        return this.selected;
    }

    public void setSelected(StoragePosition selected) {
        this.selected = selected;
    }

    public boolean isDrawerOut() {
        return this.drawerOut;
    }

    public int getDrawerOffset() {
        return this.drawerOffset;
    }

    public int getPartyWidth() {
        return this.partyWidth;
    }
}

