/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.pokemon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleMenuScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.PokemonMenuButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemonPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ChoosePokemon
extends BattleMenuScreen<PokemonMenuButton> {
    public ChoosePokemon(BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public ITextComponent func_231171_q_() {
        return new TranslationTextComponent("gui.mainmenu.pokemon");
    }

    @Override
    public List<PokemonMenuButton> generateButtons() {
        HashSet inBattle = Sets.newHashSet();
        ArrayList party = Lists.newArrayList();
        if (this.bm.teamPokemon != null) {
            for (UUID uuid : this.bm.teamPokemon) {
                Optional<PixelmonClientData> pixelmon = this.bm.fullOurPokemon.stream().filter(p -> p.pokemonUUID.equals(uuid)).findFirst();
                pixelmon.ifPresent(inBattle::add);
            }
        }
        for (PixelmonClientData pig2 : this.bm.fullOurPokemon) {
            if (inBattle.contains(pig2) || !(pig2.health.get() > 0.0)) continue;
            party.add(pig2);
        }
        party.removeIf(pig -> pig.isSwitchingIn);
        ArrayList buttons = Lists.newArrayList();
        for (int i = 0; i < party.size(); ++i) {
            PokemonMenuButton button = new PokemonMenuButton(i, (PixelmonClientData)party.get(i), this);
            buttons.add(button);
        }
        return buttons;
    }

    @Override
    public void render(MatrixStack matrix, int width, int height, int mouseX, int mouseY, float partialTicks) {
        super.render(matrix, width, height, mouseX, mouseY, partialTicks);
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.menuElement.isMouseOver(mouseX, mouseY)) {
            if (this.menuElement.isOverReturnButton(mouseX, mouseY)) {
                this.bm.setMode(BattleMode.MAIN_MENU);
            } else if (!this.menuElement.handleClickPageTurn(mouseX, mouseY)) {
                List buttons = this.menuElement.getPageButtons();
                for (PokemonMenuButton button : buttons) {
                    if (!button.func_231044_a_(mouseX, mouseY, 0)) continue;
                    this.bm.selectedActions.add(new SwitchPokemonPacket(button.getPig().pokemonUUID, this.bm.battleControllerIndex, this.bm.getCurrentPokemon().pokemonUUID, false));
                    button.getPig().isSwitchingIn = true;
                    this.bm.selectedMove();
                }
            }
        }
    }
}

