/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera.movement;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetLocation;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PlayerControlledMovement
extends CameraMovement {
    private Vector3d centerPos;
    private Vector3d baseVec;
    private float radius = 0.0f;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private boolean spherePosChanged = false;
    private boolean initSphere = false;

    public PlayerControlledMovement(World world, CameraEntity entityCamera) {
        super(world, entityCamera);
    }

    @Override
    public void setRandomPosition(CameraTarget t) {
        Direction direction = Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176734_d();
        this.camera.func_70107_b(this.camera.func_226277_ct_() + (double)direction.func_82601_c(), this.camera.func_226278_cu_() + 2.0, this.camera.func_226281_cx_() + (double)direction.func_82599_e());
    }

    @Override
    public void onLivingUpdate() {
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (!this.initSphere) {
            this.generateSphere();
        }
        if (pix == null) {
            return;
        }
        PixelmonEntity opp = this.getOpponentPokemon();
        this.centerPos = new Vector3d(pix.func_226277_ct_(), pix.func_226278_cu_(), pix.func_226281_cx_());
        if (opp != null) {
            this.centerPos = new Vector3d((this.centerPos.field_72450_a + opp.func_226277_ct_()) / 2.0, (this.centerPos.field_72448_b + opp.func_226278_cu_()) / 2.0, (this.centerPos.field_72449_c + opp.func_226281_cx_()) / 2.0);
        }
        ClientProxy.battleManager.getPokeballEntity().ifPresent(entity -> {
            if (entity.func_213303_ch().func_82617_b() > 0.0 && (entity.func_213322_ci().func_82617_b() != 0.0 || !entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_150350_a))) {
                this.centerPos = entity.func_213303_ch();
            }
        });
        this.camera.setTarget(new CameraTargetLocation(this.centerPos.field_72450_a, this.centerPos.field_72448_b, this.centerPos.field_72449_c));
        this.baseVec = this.centerPos.func_72432_b();
        this.updatePosition();
    }

    @Override
    public void updatePosition() {
        Matrix3f mat = this.constructYawMatrix();
        if (this.baseVec == null) {
            return;
        }
        Vector3d newPos = PlayerControlledMovement.multiply(mat, this.baseVec);
        mat = this.constructRotMatrix(newPos.func_72431_c(new Vector3d(0.0, 1.0, 0.0)), this.pitch);
        Vector3d rotPos = PlayerControlledMovement.multiply(mat, newPos);
        Vector3d testPos = new Vector3d(this.centerPos.field_72450_a + rotPos.field_72450_a * (double)this.radius, this.centerPos.field_72448_b + rotPos.field_72448_b * (double)this.radius, this.centerPos.field_72449_c + rotPos.field_72449_c * (double)this.radius);
        this.camera.func_70107_b(testPos.field_72450_a, testPos.field_72448_b, testPos.field_72449_c);
        this.camera.updatePositionAndRotation();
    }

    private PixelmonEntity getOpponentPokemon() {
        if (this.camera.mode == CameraMode.Evolution) {
            return null;
        }
        if (ClientProxy.battleManager == null || ClientProxy.battleManager.displayedEnemyPokemon == null || ClientProxy.battleManager.displayedEnemyPokemon.length == 0) {
            return null;
        }
        UUID uuid = ClientProxy.battleManager.displayedEnemyPokemon[0].pokemonUUID;
        if (uuid != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                for (Entity entity : mc.field_71441_e.func_217416_b()) {
                    if (!entity.func_110124_au().equals(uuid)) continue;
                    return (PixelmonEntity)entity;
                }
            }
        }
        return null;
    }

    private Matrix3f constructYawMatrix() {
        return this.constructRotMatrix(new Vector3d(0.0, 1.0, 0.0), this.yaw);
    }

    private Matrix3f constructRotMatrix(Vector3d axis, float rot) {
        Matrix3f mat = new Matrix3f();
        mat.field_226097_a_ = (float)(Math.cos(rot) + axis.field_72450_a * axis.field_72450_a * (1.0 - Math.cos(rot)));
        mat.field_226098_b_ = (float)(axis.field_72450_a * axis.field_72448_b * (1.0 - Math.cos(rot)) - axis.field_72449_c * Math.sin(rot));
        mat.field_226099_c_ = (float)(axis.field_72450_a * axis.field_72449_c * (1.0 - Math.cos(rot)) + axis.field_72448_b * Math.sin(rot));
        mat.field_226100_d_ = (float)(axis.field_72450_a * axis.field_72448_b * (1.0 - Math.cos(rot)) + axis.field_72449_c * Math.sin(rot));
        mat.field_226101_e_ = (float)(Math.cos(rot) + axis.field_72448_b * axis.field_72448_b * (1.0 - Math.cos(rot)));
        mat.field_226102_f_ = (float)(axis.field_72448_b * axis.field_72449_c * (1.0 - Math.cos(rot)) - axis.field_72450_a * Math.sin(rot));
        mat.field_226103_g_ = (float)(axis.field_72450_a * axis.field_72449_c * (1.0 - Math.cos(rot)) - axis.field_72448_b * Math.sin(rot));
        mat.field_226104_h_ = (float)(axis.field_72448_b * axis.field_72449_c * (1.0 - Math.cos(rot)) + axis.field_72450_a * Math.sin(rot));
        mat.field_226105_i_ = (float)(Math.cos(rot) + axis.field_72449_c * axis.field_72449_c * (1.0 - Math.cos(rot)));
        return mat;
    }

    public static Vector3d multiply(Matrix3f matrix, Vector3d vector) {
        double x = (double)matrix.field_226097_a_ * vector.field_72450_a + (double)matrix.field_226098_b_ * vector.field_72448_b + (double)matrix.field_226099_c_ * vector.field_72449_c;
        double y = (double)matrix.field_226100_d_ * vector.field_72450_a + (double)matrix.field_226101_e_ * vector.field_72448_b + (double)matrix.field_226102_f_ * vector.field_72449_c;
        double z = (double)matrix.field_226103_g_ * vector.field_72450_a + (double)matrix.field_226104_h_ * vector.field_72448_b + (double)matrix.field_226105_i_ * vector.field_72449_c;
        return new Vector3d(x, y, z);
    }

    public void generateSphere() {
        PlayerEntity player;
        this.initSphere = true;
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (pix == null) {
            player = ClientProxy.battleManager.getViewPlayer();
            this.centerPos = player.func_213303_ch();
        } else {
            this.centerPos = new Vector3d(pix.func_226277_ct_(), pix.func_226278_cu_(), pix.func_226281_cx_());
        }
        player = ClientProxy.battleManager.getViewPlayer();
        PixelmonEntity opp = this.getOpponentPokemon();
        if (opp != null) {
            this.centerPos = new Vector3d((this.centerPos.field_72450_a + opp.func_226277_ct_()) / 2.0, (this.centerPos.field_72448_b + opp.func_226278_cu_()) / 2.0, (this.centerPos.field_72449_c + opp.func_226281_cx_()) / 2.0);
        }
        Vector3d playerPos = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + 2.0, player.func_226281_cx_());
        this.baseVec = this.centerPos.func_72432_b();
        this.pitch = 0.7853982f;
        this.yaw = 0.0f;
        this.radius = (float)playerPos.func_72438_d(this.centerPos) + 2.0f;
        this.radius = this.radius < 10.0f ? 10.0f : this.radius;
        this.spherePosChanged = true;
        ClientProxy.battleManager.setViewEntity((Entity)this.camera);
    }

    @Override
    public void generatePositions() {
    }

    @Override
    public void handleMouseMovement(double dx, double dy, int dwheel) {
        if (dx != 0.0 || dy != 0.0 || dwheel != 0) {
            this.yaw = (float)((double)this.yaw - dx * (double)0.005f);
            this.pitch = (float)((double)this.pitch - dy * (double)0.008f);
            this.radius -= (float)dwheel;
            if (this.camera.mode == CameraMode.Battle) {
                if (this.radius < 4.0f) {
                    this.radius = 4.0f;
                }
            } else if (this.radius < 2.0f) {
                this.radius = 2.0f;
            }
            if (this.radius > 50.0f) {
                this.radius = 50.0f;
            }
            this.spherePosChanged = true;
        }
    }
}

