/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ZygardeCellTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int MAX_SP_AGE = 12000;
    private static final int MAX_MP_AGE = 36000;
    private int age;
    private boolean isPermanent = false;
    private ZygardeCubeItem.CoreType coreType = ZygardeCubeItem.CoreType.RANDOM;
    private final Map<UUID, Long> encounters = Maps.newHashMap();

    public ZygardeCellTileEntity() {
        super((TileEntityType)TileEntityRegistration.ZYGARDE_CELL.get());
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public void setPermanent(boolean permanent) {
        this.isPermanent = permanent;
        if (!this.isPermanent) {
            this.encounters.clear();
        }
    }

    public ZygardeCubeItem.CoreType getCoreType() {
        return this.coreType;
    }

    public void setCoreType(ZygardeCubeItem.CoreType coreType) {
        this.coreType = coreType;
    }

    public boolean addEncounter(UUID uuid) {
        if (this.encounters.containsKey(uuid)) {
            return false;
        }
        this.encounters.put(uuid, this.field_145850_b.func_82737_E());
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.age;
        if (!this.isPermanent() && this.age > (ServerLifecycleHooks.getCurrentServer().func_71264_H() ? 12000 : 36000)) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Age")) {
            this.age = compound.func_74762_e("Age");
        }
        if (compound.func_74764_b("isPermanent")) {
            this.isPermanent = compound.func_74767_n("isPermanent");
            this.encounters.clear();
            if (compound.func_74764_b("Encounters")) {
                ListNBT list = compound.func_150295_c("Encounters", 10);
                for (INBT base : list) {
                    CompoundNBT tag = (CompoundNBT)base;
                    UUID uuid = tag.func_186857_a("UUID");
                    long time = tag.func_74763_f("time");
                    this.encounters.put(uuid, time);
                }
            }
        } else {
            this.isPermanent = false;
        }
        this.coreType = compound.func_74764_b("CoreType") ? ZygardeCubeItem.CoreType.fromIndex(compound.func_74771_c("CoreType")) : ZygardeCubeItem.CoreType.RANDOM;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Age", this.age);
        compound.func_74757_a("isPermanent", this.isPermanent);
        if (this.isPermanent && !this.encounters.isEmpty()) {
            ListNBT list = new ListNBT();
            for (Map.Entry<UUID, Long> entry : this.encounters.entrySet()) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_186854_a("UUID", entry.getKey());
                tag.func_74772_a("time", entry.getValue().longValue());
                list.add((Object)tag);
            }
            compound.func_218657_a("Encounters", (INBT)list);
        }
        if (this.coreType != ZygardeCubeItem.CoreType.RANDOM) {
            compound.func_74774_a("CoreType", (byte)this.coreType.ordinal());
        }
        return compound;
    }
}

