/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PokeDisplayTileEntity
extends TileEntity
implements ITickableTileEntity {
    private Pokemon storedPoke;
    private String originalForm = null;
    private String originalPalette = null;
    private PixelmonEntity storedEntity;
    private String label = "";
    private EnumStatueTextureType textureMode = EnumStatueTextureType.OriginalTexture;
    private AnimationType animation = AnimationType.IDLE;
    private int animationFrame = 0;
    private boolean animate = true;
    private boolean isFlying = false;
    private Optional<UUID> locked = Optional.empty();

    public PokeDisplayTileEntity() {
        super((TileEntityType)TileEntityRegistration.POKE_DISPLAY.get());
    }

    public void setLocked(PlayerEntity player) {
        if (player == null) {
            this.locked = Optional.empty();
            return;
        }
        this.locked = Optional.ofNullable(player.func_110124_au());
    }

    public boolean isLocked() {
        return this.locked.isPresent();
    }

    public boolean isLockedBy(PlayerEntity player) {
        return this.isLocked() && Objects.equals(this.locked.get(), player.func_110124_au());
    }

    public Optional<Pokemon> getStoredPoke() {
        return Optional.ofNullable(this.storedPoke);
    }

    public PixelmonEntity getStoredEntity() {
        if (this.storedEntity == null) {
            this.setStoredPoke(null);
        }
        return this.storedEntity;
    }

    public void setStoredPoke(Pokemon storedPoke) {
        this.storedPoke = storedPoke;
        if (storedPoke != null) {
            this.storedEntity = storedPoke.getOrCreatePixelmon(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5, 0.0f, 0.0f);
            this.originalForm = storedPoke.getForm().getName();
            this.originalPalette = storedPoke.getPalette().getName();
        } else {
            this.storedEntity = PokemonFactory.create(PixelmonSpecies.MISSINGNO.getValueUnsafe()).getOrCreatePixelmon(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5, 0.0f, 0.0f);
            this.storedEntity.getPokemon().setGrowth(EnumGrowth.Ordinary);
        }
        this.storedEntity.setDisableNametag(true);
        this.storedEntity.setAnimation(this.animation);
        if (!this.animate) {
            if (this.storedEntity.getAnimationVariables() != null && this.storedEntity.getAnimationVariables().getCounter(-1) != null) {
                this.storedEntity.getAnimationVariables().getCounter((int)-1).value = this.animationFrame;
            } else {
                this.animate = true;
            }
        }
        if (this.textureMode.color != null) {
            this.storedEntity.setColor(this.textureMode.color);
        }
        if (this.textureMode.texture != null) {
            this.storedEntity.setOverrideTexture(this.textureMode.texture);
        }
        if (this.isFlying) {
            this.storedEntity.setAnimation(AnimationType.FLY);
        }
        this.func_70296_d();
    }

    public String getOriginalForm() {
        return this.originalForm;
    }

    public void setOriginalForm(String form) {
        this.originalForm = form;
        this.func_70296_d();
    }

    public String getOriginalPalette() {
        return this.originalPalette;
    }

    public void setOriginalPalette(String palette) {
        this.originalPalette = palette;
        this.func_70296_d();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public EnumStatueTextureType getTextureMode() {
        return this.textureMode;
    }

    public void setTextureMode(EnumStatueTextureType textureMode) {
        this.textureMode = textureMode;
        if (textureMode.color != null) {
            this.getStoredEntity().setColor(textureMode.color);
        }
        this.getStoredEntity().setOverrideTexture(textureMode.texture);
    }

    public AnimationType getAnimation() {
        return this.animation;
    }

    public void setAnimation(AnimationType animation) {
        this.animation = animation;
        this.getStoredEntity().setAnimation(animation);
    }

    public int getAnimationFrame() {
        return this.animationFrame;
    }

    public void setAnimationFrame(int animationFrame) {
        this.animationFrame = animationFrame;
        this.storedEntity.getAnimationVariables().getCounter((int)-1).value = animationFrame;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.isFlying = flying;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.animate) {
            this.getStoredEntity().getAnimationVariables().tick();
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 2, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (this.storedPoke != null) {
            nbt.func_218657_a("PokeDisplayPokemon", (INBT)this.storedPoke.writeToNBT(new CompoundNBT()));
        }
        if (this.originalForm != null) {
            nbt.func_74778_a("PokeDisplayOriginalForm", this.originalForm);
        }
        if (this.originalPalette != null) {
            nbt.func_74778_a("PokeDisplayOriginalPalette", this.originalPalette);
        }
        nbt.func_74778_a("PokeDisplayLabel", this.label);
        nbt.func_74768_a("PokeDisplayTextureMode", this.textureMode.ordinal());
        nbt.func_74768_a("PokeDisplayAnimation", this.animation.ordinal());
        nbt.func_74757_a("PokeDisplayAnimate", this.animate);
        nbt.func_74757_a("PokeDisplayFlying", this.isFlying);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        if (nbt.func_74764_b("PokeDisplayLabel")) {
            this.label = nbt.func_74779_i("PokeDisplayLabel");
        }
        if (nbt.func_74764_b("PokeDisplayTextureMode")) {
            this.textureMode = EnumStatueTextureType.values()[nbt.func_74762_e("PokeDisplayTextureMode")];
        }
        if (nbt.func_74764_b("PokeDisplayAnimation")) {
            this.animation = AnimationType.values()[nbt.func_74762_e("PokeDisplayAnimation")];
        }
        if (nbt.func_74764_b("PokeDisplayAnimate")) {
            this.animate = nbt.func_74767_n("PokeDisplayAnimate");
        }
        if (nbt.func_74764_b("PokeDisplayFlying")) {
            this.isFlying = nbt.func_74767_n("PokeDisplayFlying");
        }
        if (nbt.func_74764_b("PokeDisplayPokemon")) {
            this.setStoredPoke(PokemonFactory.create(nbt.func_74775_l("PokeDisplayPokemon")));
        } else {
            this.setStoredPoke(null);
        }
        if (nbt.func_74764_b("PokeDisplayOriginalForm")) {
            this.originalForm = nbt.func_74779_i("PokeDisplayOriginalForm");
        } else {
            this.setOriginalForm(null);
        }
        if (nbt.func_74764_b("PokeDisplayOriginalPalette")) {
            this.originalPalette = nbt.func_74779_i("PokeDisplayOriginalPalette");
        } else {
            this.setOriginalPalette(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFrameCount() {
        if (!(this.getModel() instanceof PixelmonModelSmd)) {
            return 0;
        }
        ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
        model.setAnimation(this.getAnimation());
        SmdAnimationSequence sequence = model.currentSequence;
        return sequence == null || sequence.current() == null ? 0 : sequence.current().totalFrames;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AnimationType> getAllAnimations() {
        if (!(this.getModel() instanceof PixelmonModelSmd)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(((PixelmonModelSmd)this.getModel()).theModel.anims.keySet());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Model getModel() {
        return this.getStoredEntity().getPalette().getModelLocators()[0].getModel().getModel();
    }
}

