/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.blocks.tileentity.IBasicInventory;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class InventoryTileEntity
extends TileEntity
implements IBasicInventory,
INamedContainerProvider {
    private final int inventorySize;
    private final int rows;
    private final String inventoryName;
    private NonNullList<ItemStack> contents;
    private String customName;

    protected InventoryTileEntity(TileEntityType<?> type, String inventoryName, int rows) {
        super(type);
        this.rows = rows;
        this.inventorySize = rows * 9;
        this.inventoryName = inventoryName;
        this.contents = NonNullList.func_191197_a((int)this.inventorySize, (Object)ItemStack.field_190927_a);
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (nbt.func_74764_b("Items")) {
            ListNBT itemsList = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundNBT nbttagcompound = itemsList.func_150305_b(i);
                byte slot = nbttagcompound.func_74771_c("Slot");
                if (slot < 0 || slot >= this.contents.size()) continue;
                this.contents.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
            }
        }
    }

    public boolean addToInventory(ItemStack stack) {
        for (int i = 0; i < this.contents.size(); ++i) {
            if (((ItemStack)this.contents.get(i)).func_190926_b()) {
                this.contents.set(i, (Object)stack);
                return true;
            }
            if (((ItemStack)this.contents.get(i)).func_190916_E() >= 64) continue;
            if (((ItemStack)this.contents.get(i)).func_190916_E() + stack.func_190916_E() > 64) {
                stack.func_190920_e((((ItemStack)this.contents.get(i)).func_190916_E() + stack.func_190916_E()) % 64);
                ((ItemStack)this.contents.get(i)).func_190920_e(64);
                return this.addToInventory(stack);
            }
            ((ItemStack)this.contents.get(i)).func_190920_e(((ItemStack)this.contents.get(i)).func_190916_E() + stack.func_190916_E());
            return true;
        }
        return false;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        ListNBT itemsList = new ListNBT();
        nbt.func_218657_a("Items", (INBT)itemsList);
        for (int slot = 0; slot < this.contents.size(); ++slot) {
            if (((ItemStack)this.contents.get(slot)).func_190926_b()) continue;
            CompoundNBT item = ((ItemStack)this.contents.get(slot)).serializeNBT();
            item.func_74774_a("Slot", (byte)slot);
            itemsList.add((Object)item);
        }
        return nbt;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack == null || itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.contents.get(index)).func_190926_b()) {
            if (((ItemStack)this.contents.get(index)).func_190916_E() <= count) {
                ItemStack itemStack = (ItemStack)this.contents.get(index);
                this.contents.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemstack = ((ItemStack)this.contents.get(index)).func_77979_a(count);
            if (((ItemStack)this.contents.get(index)).func_190916_E() == 0) {
                this.contents.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = (ItemStack)this.contents.get(index);
        this.contents.set(index, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
        return itemStack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public String getCustomName() {
        return this.hasCustomName() ? this.customName : this.inventoryName;
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new StringTextComponent(this.getCustomName()) : new TranslationTextComponent(this.getCustomName());
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerIn) {
        ContainerType containerType = ContainerType.field_221509_c;
        switch (this.rows) {
            case 1: {
                containerType = ContainerType.field_221507_a;
                break;
            }
            case 2: {
                containerType = ContainerType.field_221508_b;
                break;
            }
            case 3: {
                containerType = ContainerType.field_221509_c;
                break;
            }
            case 4: {
                containerType = ContainerType.field_221510_d;
                break;
            }
            case 5: {
                containerType = ContainerType.field_221511_e;
                break;
            }
            case 6: {
                containerType = ContainerType.field_221512_f;
            }
        }
        return new ChestContainer(containerType, id, playerInventory, (IInventory)this, this.rows);
    }

    public int func_70302_i_() {
        return this.inventorySize;
    }
}

