/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.events.CurryFinishedEvent;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.client.gui.machines.cookingpot.CookingPotContainer;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryKey;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.CurryKeyItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;

public class CookingPotTileEntity
extends TileEntity
implements IInventory,
ITickableTileEntity,
INamedContainerProvider {
    public int renderPass = 0;
    public ItemStackHandler itemStacks = new ItemStackHandler(11){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 10) {
                return stack.func_77973_b() instanceof CurryKeyItem;
            }
            return stack.func_77973_b() instanceof BerryItem;
        }
    };
    private boolean cooking = false;
    private int cookingTicks = 0;
    private int berryQuality = 0;
    private EnumBerryFlavor cookingFlavor = EnumBerryFlavor.NONE;
    public double fanningPoints = 0.0;
    private double stirringPoints = 0.0;
    private EnumCurryKey curryKey = EnumCurryKey.PLAIN;
    private ServerPlayerEntity startingPlayer = null;
    public double frame = 0.0;

    public CookingPotTileEntity() {
        super((TileEntityType)TileEntityRegistration.COOKING_POT.get());
    }

    public int func_70302_i_() {
        return this.itemStacks.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.itemStacks.getSlots(); ++i) {
            if (this.itemStacks.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.itemStacks.getStackInSlot(slotIndex);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!this.itemStacks.getStackInSlot(index).func_190926_b()) {
            ItemStack stack;
            if (this.itemStacks.getStackInSlot(index).func_190916_E() <= count) {
                stack = this.itemStacks.getStackInSlot(index);
                this.itemStacks.setStackInSlot(index, ItemStack.field_190927_a);
            } else {
                stack = this.itemStacks.getStackInSlot(index).func_77979_a(count);
                if (this.itemStacks.getStackInSlot(index).func_190916_E() == 0) {
                    this.itemStacks.setStackInSlot(index, ItemStack.field_190927_a);
                }
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (!this.itemStacks.getStackInSlot(index).func_190926_b()) {
            ItemStack itemStack = this.itemStacks.getStackInSlot(index);
            this.itemStacks.setStackInSlot(index, ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemStacks.setStackInSlot(index, stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        switch (slotIndex) {
            case 10: {
                return item instanceof CurryKeyItem;
            }
        }
        return item instanceof BerryItem;
    }

    public void func_174889_b(PlayerEntity playerIn) {
    }

    public void func_174886_c(PlayerEntity playerIn) {
    }

    public void func_174888_l() {
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isCooking()) {
                ++this.cookingTicks;
                if (this.cookingTicks < 300) {
                    this.fanningPoints -= 0.05;
                    this.fanningPoints = Math.max(0.0, this.fanningPoints);
                } else if (this.cookingTicks < 600) {
                    this.stirringPoints -= 0.05;
                    this.stirringPoints = Math.max(0.0, this.stirringPoints);
                    this.frame += this.stirringPoints / 20.0;
                    if (this.frame > 80.0) {
                        this.frame = 0.0;
                    }
                } else {
                    this.cooking = false;
                    ItemStack curry = new ItemStack((IItemProvider)this.curryKey.getDishItem());
                    CompoundNBT tag = curry.func_77978_p();
                    if (tag == null) {
                        tag = new CompoundNBT();
                    }
                    int quality = (int)((double)this.berryQuality + Math.max(0.0, 25.0 - Math.abs(25.0 - this.fanningPoints)) + Math.max(0.0, 25.0 - Math.abs(25.0 - this.stirringPoints)) + (double)this.curryKey.getRatingBoost());
                    EnumCurryRating rating = EnumCurryRating.ratingFromQuality(quality);
                    tag.func_74774_a("CurryQuality", (byte)rating.ordinal());
                    if (this.curryKey != EnumCurryKey.GIGANTAMIX) {
                        tag.func_74774_a("BerryFlavor", (byte)this.cookingFlavor.ordinal());
                    }
                    curry.func_77982_d(tag);
                    this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 2.5, (double)this.field_174879_c.func_177952_p(), curry));
                    Pixelmon.EVENT_BUS.post((Event)new CurryFinishedEvent(this.startingPlayer, rating, this.curryKey, this.cookingFlavor));
                    if (this.startingPlayer != null) {
                        StorageProxy.getParty(this.startingPlayer).updateSingleCurryData(this.curryKey, this.cookingFlavor, rating);
                        BlockSpawningHandler.getInstance().performBattleStartCheck(this.field_145850_b, this.field_174879_c, (Entity)this.startingPlayer, null, BattleStartTypes.CURRY, null, new Object[]{this.cookingFlavor, rating});
                    }
                    this.startingPlayer = null;
                }
                this.sendUpdates();
            }
        } else if (this.isCooking()) {
            BasicParticleType type = null;
            if (this.fanningPoints > 25.0) {
                type = this.field_145850_b.field_73012_v.nextInt((int)this.fanningPoints) > 15 ? ParticleTypes.field_197594_E : ParticleTypes.field_197631_x;
            } else if ((double)this.field_145850_b.field_73012_v.nextInt(25) < this.fanningPoints) {
                type = ParticleTypes.field_197631_x;
            }
            if (type != null) {
                this.func_145831_w().func_195590_a((IParticleData)type, false, (double)this.field_174879_c.func_177958_n() + 0.5 + this.field_145850_b.field_73012_v.nextDouble() / 2.0 - 0.25, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5 + this.field_145850_b.field_73012_v.nextDouble() / 2.0 - 0.25, this.field_145850_b.field_73012_v.nextDouble() / 20.0, this.field_145850_b.field_73012_v.nextDouble() / 30.0, this.field_145850_b.field_73012_v.nextDouble() / 20.0);
            }
            if (this.stirringPoints > 25.0 && this.field_145850_b.field_73012_v.nextInt((int)this.stirringPoints) > 15) {
                this.func_145831_w().func_195590_a((IParticleData)ParticleTypes.field_197616_i, false, (double)this.field_174879_c.func_177958_n() + 0.5 + this.field_145850_b.field_73012_v.nextDouble() / 2.0 - 0.25, (double)this.field_174879_c.func_177956_o() + 1.25, (double)this.field_174879_c.func_177952_p() + 0.5 + this.field_145850_b.field_73012_v.nextDouble() / 2.0 - 0.25, this.field_145850_b.field_73012_v.nextDouble() / 30.0, this.field_145850_b.field_73012_v.nextDouble() / 20.0, this.field_145850_b.field_73012_v.nextDouble() / 30.0);
            }
        }
    }

    private void sendUpdates() {
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_225319_b(this.field_174879_c, state, state);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        this.func_70296_d();
    }

    public boolean isCooking() {
        return this.cooking;
    }

    public boolean canStart() {
        for (int i = 0; i < this.itemStacks.getSlots() - 1; ++i) {
            if (this.itemStacks.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void startCooking(ServerPlayerEntity player) {
        int i;
        this.startingPlayer = player;
        int[] flavors = new int[]{0, 0, 0, 0, 0};
        int count = 0;
        for (int i2 = 0; i2 < this.itemStacks.getSlots() - 1; ++i2) {
            if (this.itemStacks.getStackInSlot(i2).func_190926_b()) continue;
            BerryType berry = ((BerryItem)this.itemStacks.getStackInSlot(i2).func_77973_b()).getBerry();
            flavors[0] = flavors[0] + berry.spicy;
            flavors[1] = flavors[1] + berry.dry;
            flavors[2] = flavors[2] + berry.sweet;
            flavors[3] = flavors[3] + berry.bitter;
            flavors[4] = flavors[4] + berry.sour;
            count = (byte)(count + 1);
            this.itemStacks.getStackInSlot(i2).func_190918_g(1);
        }
        this.berryQuality = (flavors[0] + flavors[1] + flavors[2] + flavors[3] + flavors[4]) / (count + 2) + count * 2;
        int maxAt = -1;
        int maxVal = 0;
        for (i = 0; i < flavors.length; ++i) {
            if (flavors[i] <= maxVal) continue;
            maxAt = i;
            maxVal = flavors[i];
        }
        for (i = 0; i < flavors.length; ++i) {
            if (i == maxAt || flavors[i] + 20 < maxVal) continue;
            maxAt = -1;
            break;
        }
        this.cookingFlavor = maxAt != -1 ? EnumBerryFlavor.values()[maxAt] : EnumBerryFlavor.NONE;
        if (this.itemStacks.getStackInSlot(10) == null || this.itemStacks.getStackInSlot(10).func_190926_b()) {
            this.curryKey = EnumCurryKey.PLAIN;
        } else {
            this.curryKey = ((CurryKeyItem)this.itemStacks.getStackInSlot(10).func_77973_b()).getKey();
            this.itemStacks.getStackInSlot(10).func_190918_g(1);
        }
        this.fanningPoints = 15.0;
        this.stirringPoints = 10.0;
        this.cookingTicks = 0;
        this.cooking = true;
    }

    public void processCookingInteract() {
        if (this.cookingTicks < 200) {
            this.fanningPoints += 1.5;
        } else {
            this.stirringPoints += 1.5;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbtTagCompound) {
        super.func_230337_a_(state, nbtTagCompound);
        this.itemStacks.deserializeNBT(nbtTagCompound.func_74775_l("Items"));
        this.cooking = nbtTagCompound.func_74767_n("Cooking");
        this.fanningPoints = nbtTagCompound.func_74771_c("FanPoints");
        this.stirringPoints = nbtTagCompound.func_74771_c("StirPoints");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Items", (INBT)this.itemStacks.serializeNBT());
        compound.func_74757_a("Cooking", this.isCooking());
        compound.func_74774_a("FanPoints", (byte)this.fanningPoints);
        compound.func_74774_a("StirPoints", (byte)this.stirringPoints);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        compound.func_74757_a("Cooking", this.isCooking());
        compound.func_74774_a("FanPoints", (byte)this.fanningPoints);
        compound.func_74774_a("StirPoints", (byte)this.stirringPoints);
        compound.func_74780_a("frame", this.frame);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbtTagCompound = pkt.func_148857_g();
        this.cooking = nbtTagCompound.func_74767_n("Cooking");
        this.fanningPoints = nbtTagCompound.func_74771_c("FanPoints");
        this.stirringPoints = nbtTagCompound.func_74771_c("StirPoints");
        this.frame = nbtTagCompound.func_74769_h("frame");
    }

    public ITextComponent func_145748_c_() {
        return StringTextComponent.field_240750_d_;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new CookingPotContainer(id, inventory, this);
    }
}

