/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;

public class WonderRoom
extends GlobalStatusBase {
    private transient int duration = 5;

    public WonderRoom() {
        super(StatusType.WonderRoom);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.globalStatusController.removeGlobalStatus(this.type)) {
            user.bc.sendToAll("pixelmon.status.wonderroomend", new Object[0]);
        } else {
            user.bc.sendToAll("pixelmon.status.wonderroom", new Object[0]);
            user.addGlobalStatus(new WonderRoom());
        }
    }

    @Override
    public int[] modifyBaseStats(PixelmonWrapper user, int[] stats) {
        int tempDefense = stats[BattleStatsType.DEFENSE.getStatIndex()];
        stats[BattleStatsType.DEFENSE.getStatIndex()] = stats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()];
        stats[BattleStatsType.SPECIAL_DEFENSE.getStatIndex()] = tempDefense;
        return stats;
    }

    @Override
    public void applyRepeatedEffect(GlobalStatusController globalStatusController) {
        if (--this.duration <= 0) {
            globalStatusController.bc.sendToAll("pixelmon.status.wonderroomend", new Object[0]);
            globalStatusController.removeGlobalStatus(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
        WonderRoom wonderRoom = (WonderRoom)pw.bc.globalStatusController.getGlobalStatus(this.type);
        BattleAIBase ai = pw.getBattleAI();
        try {
            pw.bc.simulateMode = false;
            pw.bc.sendMessages = false;
            this.applyEffect(pw, pw);
            pw.bc.simulateMode = true;
            pw.bc.modifyStats();
            pw.bc.modifyStatsCancellable(pw);
            List<MoveChoice> bestUserChoicesAfter = ai.getBestAttackChoices(pw);
            List<List<MoveChoice>> bestOpponentChoicesAfter = ai.getBestAttackChoices(opponents);
            ai.weightFromUserOptions(pw, userChoice, bestUserChoices, bestUserChoicesAfter);
            ai.weightFromOpponentOptions(pw, userChoice, MoveChoice.splitChoices(opponents, bestOpponentChoices), bestOpponentChoicesAfter);
        }
        finally {
            pw.bc.simulateMode = false;
            if (wonderRoom != null) {
                pw.addGlobalStatus(wonderRoom);
            }
            pw.bc.simulateMode = true;
            pw.bc.sendMessages = true;
            pw.bc.modifyStats();
            pw.bc.modifyStatsCancellable(pw);
        }
    }
}

