/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SandForce;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SandRush;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SandVeil;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Sandstorm
extends Weather {
    public Sandstorm() {
        this(5);
    }

    public Sandstorm(int turnsToGo) {
        super(StatusType.Sandstorm, turnsToGo, EnumHeldItems.smoothRock, "pixelmon.effect.sandstorm", "pixelmon.status.sandstormrage", "pixelmon.status.sandstormsubside", false, false);
    }

    public Sandstorm(int turnsToGo, boolean isOverworldWeather) {
        super(StatusType.Sandstorm, turnsToGo, EnumHeldItems.smoothRock, "pixelmon.effect.sandstorm", "pixelmon.status.sandstormrage", "pixelmon.status.sandstormsubside", false, isOverworldWeather);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Sandstorm(turns);
    }

    @Override
    public void applyRepeatedEffect(BattleController bc) {
        for (PixelmonWrapper p : bc.getDefaultTurnOrder()) {
            if (this.isImmune(p)) continue;
            p.bc.sendToAll("pixelmon.status.buffetedbysandstorm", p.getNickname());
            p.doBattleDamage(p, p.getPercentMaxHealth(6.25f), DamageTypeEnum.WEATHER);
        }
    }

    @Override
    public boolean isImmune(PixelmonWrapper p) {
        Ability ability = p.getBattleAbility();
        return p.hasType(Element.GROUND, Element.ROCK, Element.STEEL) || p.isFainted() || ability instanceof MagicGuard || ability instanceof Overcoat || ability instanceof SandForce || ability instanceof SandRush || ability instanceof SandVeil || p.getUsableHeldItem().getHeldItemType() == EnumHeldItems.safetyGoggles;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (user.hasType(Element.ROCK)) {
            int n = BattleStatsType.SPECIAL_DEFENSE.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        List<Attack> moveset;
        int benefits = 0;
        if (!this.isImmune(target)) {
            --benefits;
        } else if (target.hasType(Element.ROCK)) {
            ++benefits;
        }
        Ability ability = target.getBattleAbility();
        if (ability instanceof SandForce || ability instanceof SandRush || ability instanceof SandVeil) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset = user.getBattleAI().getMoveset(target), AttackRegistry.WEATHER_BALL)) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.SOLAR_BEAM)) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.MOONLIGHT, AttackRegistry.MORNING_SUN, AttackRegistry.SYNTHESIS)) {
            --benefits;
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new Sandstorm(this.turnsToGo);
    }
}

