/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Thaw;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class Freeze
extends StatusPersist {
    public Freeze() {
        super(StatusType.Freeze);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Freeze.freeze(user, target);
        }
    }

    public static boolean freeze(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasType(Element.ICE)) {
            return false;
        }
        if (target.bc.globalStatusController.getWeather() instanceof Sunny) {
            return false;
        }
        TranslationTextComponent message = ChatHandler.getMessage("pixelmon.effect.frozesolid", target.getNickname());
        if (target.getSpecies().is(PixelmonSpecies.SHAYMIN) && target.getForm().isForm("sky")) {
            target.setForm("land");
            user.bc.sendToAll("pixelmon.abilities.changeform", target.getNickname());
        }
        return target.addStatus(new Freeze(), user, message);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        for (int i = 0; i < a.getMove().effects.size(); ++i) {
            EffectBase e = a.getMove().effects.get(i);
            if (!(e instanceof Thaw)) continue;
            user.removeStatus(this);
            return true;
        }
        if (RandomHelper.getRandomChance(20)) {
            user.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.frozensolid", user.getNickname());
        return false;
    }

    @Override
    public void onDamageReceived(PixelmonWrapper userWrapper, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damageType) {
        if (damageType == DamageTypeEnum.ATTACK && a != null && (a.getType() == Element.FIRE || a.isAttack(AttackRegistry.SCALD, AttackRegistry.STEAM_ERUPTION))) {
            pokemon.removeStatus(this);
        }
    }

    @Override
    public StatusPersist restoreFromNBT(CompoundNBT nbt) {
        return new Freeze();
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(Element.ICE);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.breakice";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.frozencureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        float weight = this.getWeightWithChance(100.0f);
        if (userChoice.isMiddleTier() && !userChoice.hitsAlly()) {
            for (PixelmonWrapper target : userChoice.targets) {
                if (!Freeze.freeze(pw, target)) continue;
                userChoice.raiseWeight(weight);
            }
        }
    }
}

