/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.raids;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class RaidPokemon {
    private final String name;
    private final RegistryValue<Species> species;
    private String form = null;
    private final Item item;
    private final String ability;
    private final ImmutableAttack[] attacks;

    public RaidPokemon(String name, RegistryValue<Species> species, Item item, String ability, List<ImmutableAttack> attacks) {
        this.name = name;
        this.species = species;
        this.item = item;
        this.ability = ability;
        this.attacks = attacks.toArray(new ImmutableAttack[0]);
    }

    public RaidPokemon(String name, RegistryValue<Species> species, Item item, String ability, ImmutableAttack ... attacks) {
        this.name = name;
        this.species = species;
        this.item = item;
        this.ability = ability;
        this.attacks = attacks;
    }

    public RaidPokemon setForm(String form) {
        this.form = form;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Pokemon makePokemon(int level) {
        Pokemon pokemon = PokemonFactory.create(this.species.getValueUnsafe());
        if (this.form != null) {
            pokemon.setForm(this.form);
        }
        pokemon.setLevel(level);
        if (this.item != null) {
            pokemon.setHeldItem(new ItemStack((IItemProvider)this.item));
        }
        pokemon.setAbility(AbilityRegistry.getAbility(this.ability));
        pokemon.getMoveset().clear();
        for (ImmutableAttack attack : this.attacks) {
            pokemon.getMoveset().add(new Attack(attack));
        }
        return pokemon;
    }
}

