/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WildPixelmonParticipant
extends BattleParticipant {
    private boolean isBlockBattleParticipant = false;

    public WildPixelmonParticipant(boolean isGrassBattleParticipant, PixelmonEntity ... pixelmon) {
        super(pixelmon.length);
        this.init(pixelmon);
        this.isBlockBattleParticipant = isGrassBattleParticipant;
    }

    public WildPixelmonParticipant(PixelmonEntity ... pixelmon) {
        super(pixelmon.length);
        this.init(pixelmon);
    }

    public WildPixelmonParticipant(Pokemon ... pokemon) {
        super(pokemon.length);
        this.init(pokemon);
    }

    private void init(PixelmonEntity[] pixelmon) {
        this.allPokemon = new PixelmonWrapper[pixelmon.length];
        for (int i = 0; i < pixelmon.length; ++i) {
            PixelmonWrapper pw;
            this.allPokemon[i] = pw = new PixelmonWrapper((BattleParticipant)this, pixelmon[i], i);
            this.controlledPokemon.add(pw);
        }
    }

    private void init(Pokemon[] pixelmon) {
        this.allPokemon = new PixelmonWrapper[pixelmon.length];
        for (int i = 0; i < pixelmon.length; ++i) {
            PixelmonWrapper pw;
            this.allPokemon[i] = pw = new PixelmonWrapper((BattleParticipant)this, pixelmon[i], i);
            this.controlledPokemon.add(pw);
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.WildPokemon;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.countAblePokemon() == 1;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return false;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void startBattle() {
        super.startBattle();
        boolean isBoss = false;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.entity != null) {
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
                pw.entity.func_184646_p(0.0f);
                pw.entity.func_191989_p(0.0f);
                pw.entity.func_70657_f(0.0f);
                pw.entity.field_70160_al = true;
                pw.entity.func_70661_as().func_75499_g();
                BossTier bossTier = pw.entity.getBossTier();
                if (bossTier.isBoss()) {
                    isBoss = true;
                    int lvl = 1;
                    for (BattleParticipant p : this.bc.participants) {
                        if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                        int highestLevel = ((PlayerParticipant)p).getHighestLevel();
                        lvl = Math.max(lvl, highestLevel);
                    }
                    lvl = (int)((double)lvl * bossTier.getLevelMultiplier());
                    PermanentStats permanentStats = pw.getStats();
                    permanentStats.getIVs().maximizeIVs();
                    permanentStats.getEVs().randomizeMaxEVs();
                    pw.setTempLevel(lvl += bossTier.getExtraLevels());
                }
            }
            pw.setHealth(pw.getMaxHealth());
            pw.getMoveset().forEach(attack -> {
                if (attack != null) {
                    attack.pp = attack.getMaxPP();
                }
            });
            pw.onBattlefield = true;
        }
        this.setBattleAI(isBoss ? PixelmonConfigProxy.getBattle().getBattleAIBoss().createAI(this) : PixelmonConfigProxy.getBattle().getBattleAIWild().createAI(this));
    }

    @Override
    public void endBattle(BattleEndCause cause) {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetBattleEvolution();
            if (pw.entity != null) {
                pw.entity.onEndBattle();
            }
            if (pw.entity == null || !pw.isFainted() && !this.shouldDespawn() && !this.isBlockBattleParticipant) continue;
            pw.entity.func_241204_bJ_();
        }
    }

    private boolean shouldDespawn() {
        if (PixelmonConfigProxy.getSpawning().isDespawnOnFleeOrLoss()) {
            if (this.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                return this.bc.getOpponents(this).get(0) instanceof PlayerParticipant;
            }
            return true;
        }
        return false;
    }

    @Override
    public void getNextPokemon(int position) {
    }

    @Override
    public UUID getNextPokemonUUID() {
        return null;
    }

    @Override
    public TextComponent getName() {
        String key = "";
        if (!this.controlledPokemon.isEmpty()) {
            key = "pixelmon." + ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity.getLocalizedName().toLowerCase(Locale.ROOT) + "";
        }
        return new TranslationTextComponent(key);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pw) {
        if (this.bc == null) {
            return null;
        }
        if (!pw.getMoveset().isEmpty()) {
            return this.getBattleAI().getNextMove(pw);
        }
        this.bc.setFlee(pw.getPokemonUUID());
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, UUID newPixelmonUUID) {
        return null;
    }

    @Override
    public boolean checkPokemon() {
        boolean allGood = true;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.getMoveset().isEmpty()) continue;
            pw.pokemon.getMoveset().clear();
            pw.pokemon.getMoveset().addAll(pw.pokemon.getForm().getMoves().loadMoveset(pw.getPokemonLevelNum()));
            if (!pw.getMoveset().isEmpty()) continue;
            if (PixelmonConfigProxy.getGeneral().getDebug().isPrintErrors()) {
                Pixelmon.LOGGER.info("Couldn't load " + pw.pokemon.getLocalizedName() + "'s moves.");
            }
            allGood = false;
        }
        return allGood;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    public MobEntity getEntity() {
        if (this.controlledPokemon.isEmpty()) {
            return null;
        }
        return ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity;
    }

    public PixelmonWrapper asWrapper() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pixelmonWrapper = (PixelmonWrapper)iterator.next();
            return pixelmonWrapper;
        }
        return null;
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public boolean canDynamax() {
        return false;
    }

    @Override
    public String getDisplayName() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pw = (PixelmonWrapper)iterator.next();
            return pw.getNickname();
        }
        return super.getDisplayName();
    }
}

