/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.SpawnPixelmonEntityForBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.AirSaver;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.RandomAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import com.pixelmonmod.pixelmon.battles.tasks.HPUpdateTask;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.PixelmonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BackToMainMenuPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.music.PlayBattleMusicPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import com.pixelmonmod.pixelmon.items.ShrineOrbItem;
import com.pixelmonmod.pixelmon.sounds.BattleMusicType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.eventbus.api.Event;

public class PlayerParticipant
extends BattleParticipant {
    public ServerPlayerEntity player;
    public PlayerPartyStorage party;
    long guiCheck = 0L;
    public boolean hasAmuletCoin = false;
    private int amuletCoinMultiplier = PixelmonConfigProxy.getBattle().getAmuletCoinMultiplier();
    public boolean hasHappyHour = false;
    private int happyHourMultiplier = PixelmonConfigProxy.getBattle().getHappyHourMultiplier();
    public int payDay = 0;
    public boolean enforcedRevive = false;
    private AirSaver airSaver;

    @Deprecated
    public PlayerParticipant(ServerPlayerEntity p, PixelmonEntity ... startingPixelmon) {
        super(startingPixelmon.length);
        this.player = p;
        this.loadParty(this.getStorage());
        this.initialize(p, startingPixelmon);
    }

    public PlayerParticipant(ServerPlayerEntity p, Pokemon ... startingPixelmon) {
        super(startingPixelmon.length);
        this.player = p;
        this.loadParty(this.getStorage());
        this.initialize(p, startingPixelmon);
    }

    @Deprecated
    public PlayerParticipant(boolean raid, ServerPlayerEntity p, PixelmonEntity ... startingPixelmon) {
        super(startingPixelmon.length);
        this.player = p;
        if (raid) {
            this.loadSingle(startingPixelmon[0].getPokemon());
        } else {
            this.loadParty(this.getStorage());
        }
        this.initialize(p, startingPixelmon);
    }

    public PlayerParticipant(boolean raid, ServerPlayerEntity p, Pokemon ... startingPixelmon) {
        super(startingPixelmon.length);
        this.player = p;
        if (raid) {
            this.loadSingle(startingPixelmon[0]);
        } else {
            this.loadParty(this.getStorage());
        }
        this.initialize(p, startingPixelmon);
    }

    public PlayerParticipant(ServerPlayerEntity p, List<Pokemon> teamSelection, int numControlledPokemon) {
        super(numControlledPokemon);
        this.loadParty(teamSelection);
        Pokemon[] startingPokemon = new Pokemon[numControlledPokemon];
        for (int i = 0; i < numControlledPokemon; ++i) {
            if (teamSelection.size() <= i) continue;
            startingPokemon[i] = teamSelection.get(i);
            if (Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(teamSelection.get(i)))) continue;
            PixelmonEntity pixelmonEntity = teamSelection.get(i).getOrSpawnPixelmon((Entity)p);
            pixelmonEntity.setPixelmonToFlyForBattle();
            Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(teamSelection.get(i), pixelmonEntity));
        }
        this.initialize(p, startingPokemon);
    }

    private void initialize(ServerPlayerEntity p, Pokemon ... startingPixelmon) {
        this.player = p;
        this.party = this.getStorage();
        int positionIndex = 0;
        for (Pokemon pokemon : startingPixelmon) {
            PixelmonWrapper pw;
            if (pokemon == null || (pw = this.getPokemonFromParty(pokemon.getUUID())) == null) continue;
            this.controlledPokemon.add(pw);
            pw.battlePosition = positionIndex++;
            pw.onBattlefield = true;
        }
        this.airSaver = new AirSaver(p);
        p.func_70637_d(false);
        p.field_191988_bg = 0.0f;
        p.field_70702_br = 0.0f;
        p.func_226284_e_(false);
    }

    private void initialize(ServerPlayerEntity p, PixelmonEntity ... startingPixelmon) {
        this.player = p;
        this.party = this.getStorage();
        int positionIndex = 0;
        for (PixelmonEntity pokemon : startingPixelmon) {
            PixelmonWrapper pw;
            if (pokemon == null || (pw = this.getPokemonFromParty(pokemon)) == null) continue;
            this.controlledPokemon.add(pw);
            pw.battlePosition = positionIndex++;
            pw.onBattlefield = true;
        }
        this.airSaver = new AirSaver(p);
        p.func_70637_d(false);
        p.field_191988_bg = 0.0f;
        p.field_70702_br = 0.0f;
        p.func_226284_e_(false);
    }

    private void enableReturnHeldItems() {
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.enableReturnHeldItem();
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Player;
    }

    @Override
    public boolean canGainXP() {
        return true;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        int remaining = 0;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (pixelmonWrapper == null || !pixelmonWrapper.isAlive() || this.controlledPokemon.contains(pixelmonWrapper) || pixelmonWrapper.isSwitching || this.switchingOut.contains(pixelmonWrapper)) continue;
            ++remaining;
        }
        return remaining > 0;
    }

    @Override
    public void startBattle() {
        super.startBattle();
        this.setBattleAI(new RandomAI(this));
        this.player.field_71075_bZ.field_75102_a = true;
        this.player.field_70144_Y = 1.0f;
        boolean useTurnTime = false;
        int activateTime = 0;
        int turnTime = 0;
        if (this.bc.rules.getOrDefault(BattleRuleRegistry.TURN_TIME) > 0) {
            useTurnTime = true;
            activateTime = this.bc.rules.getOrDefault(BattleRuleRegistry.TURN_TIME);
            turnTime = this.bc.rules.getOrDefault(BattleRuleRegistry.TURN_TIME);
        } else if (PixelmonServerConfig.afkHandlerOn) {
            useTurnTime = true;
            activateTime = PixelmonServerConfig.afkTimerActivateSeconds;
            turnTime = PixelmonConfigProxy.getGeneral().getAfkHandler().getAfkTimerTurnSeconds();
        }
        ParticipantType[][] battleType = this.bc.getBattleType(this);
        int catchCombo = 0;
        if (this.getOpponents().stream().allMatch(it -> it instanceof WildPixelmonParticipant) && this.getOpponentPokemon().stream().allMatch(it -> it.getSpecies() == this.party.transientData.captureCombo.getCurrentSpecies())) {
            catchCombo = this.party.transientData.captureCombo.getCurrentCombo();
        }
        StartBattlePacket startPacket = useTurnTime ? new StartBattlePacket(this.bc.battleIndex, battleType, activateTime, turnTime, catchCombo, this.bc.rules) : new StartBattlePacket(this.bc.battleIndex, battleType, -1, -1, catchCombo, this.bc.rules);
        NetworkHelper.sendPacket(startPacket, this.player);
        this.party.playerPokedex.update();
        if (this.bc.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL).booleanValue() || PixelmonConfigProxy.getBattle().isReturnHeldItems() && this.bc.isPvP()) {
            this.enableReturnHeldItems();
        }
        NetworkHelper.sendPacket(new SetAllBattlingPokemonPacket(PixelmonClientData.convertToGUI(Arrays.asList(this.allPokemon)), true), this.player);
        NetworkHelper.sendPacket(new SetBattlingPokemonPacket(this.getTeamPokemonList()), this.player);
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.pokemon.getPixelmonEntity() == null) {
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
                pw.entity.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
                pw.entity.func_184646_p(0.0f);
                pw.entity.func_191989_p(0.0f);
                pw.entity.func_70657_f(0.0f);
                pw.entity.field_70160_al = true;
                pw.entity.func_70661_as().func_75499_g();
                pw.entity.func_70012_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), this.player.field_70177_z, 0.0f);
                pw.entity.releaseFromPokeball();
            }
            if (pw.entity != null) {
                pw.entity.battleController = this.bc;
                continue;
            }
            pw.bc = this.bc;
        }
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonList() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            teamPokemon.addAll(p.controlledPokemon);
        }
        return teamPokemon;
    }

    @Override
    public void endBattle(BattleEndCause cause) {
        if (!this.player.func_184812_l_()) {
            this.player.field_71075_bZ.field_75102_a = false;
        }
        this.player.func_195064_c(new EffectInstance((Effect)EffectRegistration.AVOIDANCE.get(), 200, 0, false, PixelmonConfigProxy.getGraphics().getPotionParticlesVisible()));
        this.player.field_70144_Y = 0.0f;
        String burmyForm = null;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (!pixelmonWrapper.changeBurmy || this.controlledPokemon.isEmpty()) continue;
            if (burmyForm == null) {
                burmyForm = PixelmonForms.getFromTerrain(TerrainExamine.getTerrain((PixelmonWrapper)this.controlledPokemon.get(0)));
            }
            pixelmonWrapper.pokemon.setForm(burmyForm);
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetOnSwitch();
            pw.resetBattleEvolution();
            if (pw.entity != null) {
                pw.entity.onEndBattle();
                this.retrieveEntityDuringBattleUnlessRiding(pw);
            }
            if (cause != BattleEndCause.FLEE && cause != BattleEndCause.FORFEIT && cause != BattleEndCause.FORCE) continue;
            this.resetPayDay();
        }
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            pixelmonWrapper.resetBattleEvolution();
            pixelmonWrapper.writeToNBT();
        }
        if (this.payDay > 0 && this.hasMorePokemon()) {
            this.payDay *= this.getPrizeMoneyMultiplier();
            BankAccountProxy.getBankAccount(this.player).ifPresent(account -> {
                account.add(this.payDay);
                ChatHandler.sendBattleMessage((Entity)this.getEntity(), "pixelmon.effect.paydayend", this.getName(), this.payDay);
            });
        }
        if (cause == BattleEndCause.FLEE && this.getOpponents().stream().allMatch(it -> it instanceof WildPixelmonParticipant) && this.bc.getOpponentPokemon(this).stream().anyMatch(it -> it.willTryFlee)) {
            this.party.transientData.captureCombo.clearCombo();
        }
        NetworkHelper.sendPacket(new ExitBattlePacket(), this.player);
        if (this.bc != null && this.bc.participants.size() == 2 && this.bc.otherParticipant(this) instanceof PlayerParticipant) {
            if (!this.hasMorePokemon()) {
                this.party.stats.addLoss();
            } else {
                this.party.stats.addWin();
            }
        }
    }

    @Override
    public void getNextPokemon(int position) {
        if (position >= this.controlledPokemon.size() || this.bc.battleEnded) {
            this.wait = false;
            return;
        }
        boolean switching = false;
        PixelmonWrapper switchingPokemon = (PixelmonWrapper)this.controlledPokemon.get(position);
        switchingPokemon.isSwitching = true;
        switching = true;
        switchingPokemon.wait = true;
        if (switchingPokemon.newPokemonUUID == null) {
            NetworkHelper.sendPacket(new EnforcedSwitchTask(position), this.player);
        }
        if (!switching) {
            this.wait = false;
        }
    }

    public int getPrizeMoneyMultiplier() {
        int multiplier = 1;
        if (this.hasAmuletCoin) {
            multiplier *= this.amuletCoinMultiplier;
        }
        if (this.hasHappyHour) {
            multiplier *= this.happyHourMultiplier;
        }
        return multiplier;
    }

    @Override
    public UUID getNextPokemonUUID() {
        Pokemon first = this.party.findOne(pokemon -> pokemon.canBattle() && pokemon.getPixelmonEntity() == null);
        if (first == null) {
            return null;
        }
        return first.getUUID();
    }

    @Override
    public TextComponent getName() {
        return new StringTextComponent(this.player.func_145748_c_().func_150261_e());
    }

    @Override
    public void selectAction() {
        this.getMove(null);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pokemon) {
        if (this.bc == null) {
            return null;
        }
        ArrayList pokemonToChoose = Lists.newArrayList();
        ArrayList canSwitchList = Lists.newArrayList();
        boolean canFlee = true;
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (p.getMoveset().isEmpty()) {
                this.bc.endBattle(BattleEndCause.FORCE);
                return null;
            }
            if (p.attack == null || !p.attack.doesPersist(p)) {
                if (p.skipsTurn()) {
                    p.wait = false;
                    continue;
                }
                pokemonToChoose.add(p.getPokemonUUID());
                boolean[] canExit = PlayerParticipant.canSwitch(p);
                canSwitchList.add(canExit[0]);
                canFlee = canFlee && canExit[1];
                p.wait = true;
                continue;
            }
            p.wait = false;
        }
        if (!pokemonToChoose.isEmpty()) {
            NetworkHelper.sendPacket(new BackToMainMenuPacket(canSwitchList, canFlee, pokemonToChoose), this.player);
            ArrayList<Spectator> playerSpectators = this.bc.getPlayerSpectators(this);
            ArrayList trueList = Lists.newArrayList(Collections.nCopies(pokemonToChoose.size(), true));
            playerSpectators.forEach(spectator -> spectator.sendMessage(new BackToMainMenuPacket(trueList, true, pokemonToChoose)));
        }
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, UUID newPixelmonUUID) {
        double x = this.player.func_226277_ct_();
        double y = this.player.func_226278_cu_();
        double z = this.player.func_226281_cx_();
        String beforeName = pw.getNickname();
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonUUID);
        pw.beforeSwitch(newWrapper);
        if (!pw.isFainted() && !pw.nextSwitchIsMove) {
            ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.enough", pw.getNickname());
            this.bc.sendToOthers("playerparticipant.withdrew", this, this.player.func_145748_c_().func_150261_e(), beforeName);
        }
        if (!this.bc.simulateMode) {
            Pokemon newPokemon;
            if (pw.entity != null) {
                this.retrieveEntityDuringBattleUnlessRiding(pw);
                this.switchingOut.remove(pw);
            }
            if (!Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Pre(newPokemon = this.party.find(newPixelmonUUID)))) {
                PixelmonEntity pixelmon = newPokemon.getOrSpawnPixelmon((Entity)this.player);
                pixelmon.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
                pixelmon.field_70714_bg.func_220880_a(Goal.Flag.JUMP);
                pixelmon.field_70714_bg.func_220880_a(Goal.Flag.TARGET);
                pixelmon.func_184646_p(0.0f);
                pixelmon.func_191989_p(0.0f);
                pixelmon.func_70657_f(0.0f);
                pixelmon.field_70160_al = true;
                pixelmon.func_70661_as().func_75499_g();
                pixelmon.func_213293_j(0.0, 0.0, 0.0);
                pixelmon.func_70012_b(x, y, z, this.player.field_70177_z, 0.0f);
                pixelmon.setPixelmonToFlyForBattle();
                newWrapper.entity = pixelmon;
                Pixelmon.EVENT_BUS.post((Event)new SpawnPixelmonEntityForBattleEvent.Post(newPokemon, pixelmon));
            }
        }
        newWrapper.battlePosition = pw.battlePosition;
        newWrapper.onBattlefield = true;
        pw.onBattlefield = false;
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.go", newWrapper.getNickname());
        this.bc.sendToOthers("battlecontroller.sendout", this, this.player.func_145748_c_().func_150261_e(), newWrapper.getNickname());
        int index = this.controlledPokemon.indexOf(pw);
        this.controlledPokemon.set(index, newWrapper);
        this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (Pokemon pokemon : this.party.getTeam()) {
            if (!pokemon.getMoveset().isEmpty()) continue;
            ChatHandler.sendChat((Entity)this.player, "playerparticipant.load", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
        pw.update(EnumUpdateType.HP);
    }

    @Override
    public LivingEntity getEntity() {
        return this.player;
    }

    @Override
    public void updateOtherPokemon() {
        ArrayList<Spectator> playerSpectators;
        if (this.bc == null) {
            this.endBattle(BattleEndCause.FORCE);
            return;
        }
        if (this.bc.simulateMode) {
            return;
        }
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        for (int i = 0; i < opponents.size(); ++i) {
            if (opponents.get(i) != null) continue;
            opponents.remove(i);
            --i;
        }
        if (this.bc.battleTurn == -1) {
            this.updateOpponentPokemon();
            if (this.bc.getTeam(this).size() > 1) {
                ArrayList<PixelmonWrapper> otherTeamPokemon = this.getAllyData();
                NetworkHelper.sendPacket(new SetPokemonTeamDataPacket(otherTeamPokemon), this.player);
                playerSpectators = this.bc.getPlayerSpectators(this);
                playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonTeamDataPacket(otherTeamPokemon)));
            }
        }
        if (!this.bc.battleEnded) {
            ArrayList<PixelmonWrapper> teamPokemon = this.getTeamPokemonList();
            NetworkHelper.sendPacket(new SetBattlingPokemonPacket(teamPokemon), this.player);
            playerSpectators = this.bc.getPlayerSpectators(this);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new SetBattlingPokemonPacket(teamPokemon)));
        }
    }

    public ArrayList<PixelmonWrapper> getAllyData() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> otherTeamPokemon = new ArrayList<PixelmonWrapper>(6);
        team.stream().filter(p -> p != this).forEach(p -> otherTeamPokemon.addAll(p.controlledPokemon));
        return otherTeamPokemon;
    }

    public PixelmonClientData[] getOpponentData() {
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        return PixelmonClientData.convertToGUI(opponents);
    }

    public void updateOpponentPokemon() {
        PixelmonClientData[] data = this.getOpponentData();
        NetworkHelper.sendPacket(new SetPokemonBattleDataPacket(data), this.player);
        ArrayList<Spectator> playerSpectators = this.bc.getPlayerSpectators(this);
        playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleDataPacket(data)));
    }

    public void updatePokemonHealth() {
        this.updateOtherPokemon();
    }

    public void checkPlayerItems() {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack item;
            int dmg;
            if (this.player.field_71071_by.field_70462_a.get(i) == null || !(((ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77973_b() instanceof ShrineOrbItem) || (dmg = (item = (ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77952_i()) >= ShrineOrbItem.full) continue;
            item.func_196085_b(dmg + 1);
            break;
        }
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (PixelmonWrapper pw : this.allPokemon) {
            lvl = Math.max(lvl, pw.getPokemonLevelNum());
        }
        return lvl;
    }

    @Override
    public void tick() {
        super.tick();
        this.airSaver.tick();
        if (this.party != null && !this.party.guiOpened) {
            this.openGui();
        }
        if (this.player.func_110143_aJ() <= 0.0f) {
            this.bc.endBattle(BattleEndCause.FORCE);
            BattleRegistry.deRegisterBattle(this.bc);
        }
    }

    public void givePlayerExp(PixelmonWrapper pixelmon) {
        int opponentPixelmonLevel = pixelmon.getPokemonLevelNum();
        int expAmount = 0;
        int divisor = 5;
        if (opponentPixelmonLevel >= 75) {
            expAmount = opponentPixelmonLevel / (divisor * 5);
            this.player.func_195068_e(expAmount);
        } else if (opponentPixelmonLevel >= 50) {
            expAmount = opponentPixelmonLevel / (divisor * 4);
            this.player.func_195068_e(expAmount);
        } else if (opponentPixelmonLevel >= 35) {
            expAmount = opponentPixelmonLevel / (divisor * 2);
            this.player.func_195068_e(expAmount);
        } else if (opponentPixelmonLevel > divisor) {
            expAmount = opponentPixelmonLevel / divisor;
            this.player.func_195068_e(expAmount);
        } else {
            this.player.func_195068_e(1);
        }
    }

    public void openGui() {
        if (this.guiCheck == 0L || System.currentTimeMillis() - this.guiCheck > 1000L) {
            OpenScreenPacket.open((PlayerEntity)this.player, EnumGuiScreen.Battle, this.bc.battleIndex);
            this.guiCheck = System.currentTimeMillis();
            NetworkHelper.sendPacket(new PlayBattleMusicPacket(this.getBattleMusicType(), -1, 0L, true), this.player);
        }
    }

    public BattleMusicType getBattleMusicType() {
        if (this.getOpponents().stream().anyMatch(p -> p.getType() == ParticipantType.RaidPokemon)) {
            return BattleMusicType.RAID;
        }
        if (this.getOpponents().stream().anyMatch(p -> p.getType() == ParticipantType.Player)) {
            return BattleMusicType.PLAYER;
        }
        if (this.getOpponents().stream().anyMatch(p -> p.getType() == ParticipantType.Trainer)) {
            if (this.getOpponents().stream().filter(p -> p.getType() == ParticipantType.Trainer && p instanceof TrainerParticipant).map(p -> (TrainerParticipant)p).anyMatch(p -> p.trainer != null && p.trainer.isGymLeader)) {
                return BattleMusicType.GYM;
            }
            return BattleMusicType.TRAINER;
        }
        if (this.getOpponents().stream().anyMatch(p -> p.getType() == ParticipantType.WildPokemon)) {
            if (this.getOpponents().stream().filter(p -> p.getType() == ParticipantType.WildPokemon && p instanceof WildPixelmonParticipant).map(BattleParticipant::getEntity).anyMatch(p -> p instanceof PixelmonEntity && ((PixelmonEntity)p).isBossPokemon())) {
                return BattleMusicType.BOSS;
            }
            if (this.getOpponents().stream().filter(p -> p.getType() == ParticipantType.WildPokemon && p instanceof WildPixelmonParticipant).map(BattleParticipant::getEntity).anyMatch(p -> p instanceof PixelmonEntity && ((PixelmonEntity)p).isLegendary())) {
                return BattleMusicType.LEGENDARY;
            }
            return BattleMusicType.WILD;
        }
        return BattleMusicType.WILD;
    }

    @Override
    public void sendDamagePacket(PixelmonWrapper user, int damage) {
        NetworkHelper.sendPacket(new HPUpdateTask(user, -damage), this.player);
    }

    @Override
    public void sendHealPacket(PixelmonWrapper target, int amount) {
        NetworkHelper.sendPacket(new HPUpdateTask(target, amount), this.player);
    }

    @Override
    public String getDisplayName() {
        return this.player.func_145748_c_().getString();
    }

    @Override
    public PlayerPartyStorage getStorage() {
        return StorageProxy.getParty(this.player);
    }

    @Override
    public boolean canMegaEvolve() {
        if (this.bc != null && this.bc.isRaid()) {
            return false;
        }
        return this.getStorage().getMegaItem().canMega();
    }

    @Override
    public boolean canDynamax() {
        BattleParticipant bp;
        if (this.bc != null && this.bc.isRaid() && (bp = this.getOpponents().get(0)) instanceof RaidPixelmonParticipant) {
            RaidPixelmonParticipant rpp = (RaidPixelmonParticipant)bp;
            return rpp.canDynamax(this);
        }
        return this.getStorage().getMegaItem().canDynamax();
    }

    @Override
    public void sendMessage(PixelmonPacket message) {
        NetworkHelper.sendPacket(message, this.player);
    }

    public int getAmuletCoinMultiplier() {
        return this.amuletCoinMultiplier;
    }

    public void setAmuletCoinMultiplier(int multiplier) {
        this.amuletCoinMultiplier = multiplier;
    }

    public int getHappyHourMultiplier() {
        return this.happyHourMultiplier;
    }

    public void setHappyHourMultiplier(int multiplier) {
        this.happyHourMultiplier = multiplier;
    }

    public void resetPayDay() {
        this.payDay = 0;
    }
}

