/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log.action.type;

import com.pixelmonmod.pixelmon.battles.controller.log.action.BattleAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import java.util.List;
import java.util.stream.Collectors;

public class TurnEndAction
extends BattleAction {
    protected final Terrain terrain;
    protected final Weather weather;
    protected final List<PixelmonWrapper> teams;

    public TurnEndAction(int turn, Terrain terrain, Weather weather, List<PixelmonWrapper> teams) {
        super(turn);
        this.terrain = terrain == null ? null : (Terrain)terrain.copy();
        this.weather = weather == null ? null : (Weather)weather.copy();
        this.teams = teams.stream().map(PixelmonWrapper::copy).collect(Collectors.toList());
    }

    @Override
    public boolean appendLog(StringBuilder builder) {
        builder.append(System.lineSeparator()).append("Turn #").append(this.turn).append(" has ended").append(System.lineSeparator());
        builder.append(" Terrain: ").append(this.terrain != null ? this.terrain.toString() : "none").append(System.lineSeparator());
        builder.append(" Weather: ").append(this.weather != null ? this.weather.toString() : "none").append(System.lineSeparator());
        builder.append(" Pokemon: ").append(System.lineSeparator());
        for (PixelmonWrapper startingTeam : this.teams) {
            builder.append(" ").append(startingTeam.toString()).append(System.lineSeparator()).append("  Stats: ").append(startingTeam.getBattleStats().toString()).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return true;
    }
}

