/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class Swap
extends SpecialAttackBase {
    String langString;
    BattleStatsType[] swapStats;

    public Swap() {
    }

    public Swap(String langString, BattleStatsType ... swapStats) {
        this.langString = langString;
        this.swapStats = swapStats;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll(this.langString, user.getNickname(), target.getNickname());
        user.getBattleStats().swapStats(target.getBattleStats(), this.swapStats);
        return AttackResult.succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            BattleStats[] originalStats = new BattleStats[]{pw.getBattleStats(), target.getBattleStats()};
            for (BattleStatsType stat : this.swapStats) {
                if (originalStats[0].getStage(stat) < originalStats[1].getStage(stat)) break;
            }
            BattleStats[] saveStats = new BattleStats[2];
            pw.bc.simulateMode = false;
            saveStats[0] = new BattleStats(originalStats[0]);
            saveStats[1] = new BattleStats(originalStats[1]);
            ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
            BattleAIBase ai = pw.getBattleAI();
            try {
                pw.getBattleStats().swapStats(target.getBattleStats(), this.swapStats);
                pw.bc.simulateMode = true;
                List<MoveChoice> bestUserChoicesAfter = ai.getBestAttackChoices(pw);
                List<List<MoveChoice>> bestOpponentChoicesAfter = ai.getBestAttackChoices(opponents);
                ai.weightFromUserOptions(pw, userChoice, bestUserChoices, bestUserChoicesAfter);
                ai.weightFromOpponentOptions(pw, userChoice, MoveChoice.splitChoices(opponents, bestOpponentChoices), bestOpponentChoicesAfter);
            }
            finally {
                pw.bc.simulateMode = false;
                for (int i = 0; i < saveStats.length; ++i) {
                    originalStats[i].copyStats(saveStats[i]);
                }
                pw.bc.simulateMode = true;
            }
        }
    }
}

