/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Conversion2
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.lastAttack == null) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        List<Element> ableTypes = this.getPossibleTypes(user, target);
        if (!ableTypes.isEmpty()) {
            Element chosenType = RandomHelper.getRandomElementFromList(ableTypes);
            user.setTempType(chosenType);
            user.bc.sendToAll("pixelmon.effect.changetype", user.getNickname(), chosenType.getLocalizedName());
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    private List<Element> getPossibleTypes(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.lastAttack == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> ableTypes = new ArrayList<Element>();
        for (Element type : Element.values()) {
            if (!(Element.getEffectiveness((Element)target.lastAttack.getType(), (Element)type).value < 1.0f)) continue;
            ableTypes.add(type);
        }
        if (user.type.size() == 1) {
            ableTypes.remove(user.type.get(0));
        }
        return ableTypes;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            pw.getBattleAI().weightTypeChange(pw, userChoice, this.getPossibleTypes(pw, target), bestUserChoices, bestOpponentChoices);
        }
    }
}

