/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Multitype;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.StanceChange;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Truant;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TranslationTextComponent;

public class ChangeAbility
extends SpecialAttackBase {
    String ability = null;

    public ChangeAbility(String ability) {
        this.ability = ability;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        Ability targetAbility = target.getBattleAbility(false);
        if (targetAbility.getClass().equals(this.ability) || targetAbility instanceof Multitype || targetAbility instanceof StanceChange || targetAbility instanceof Truant) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        user.bc.sendToAll("pixelmon.effect.entrainment", target.getNickname(), targetAbility.getTranslatedName(), new TranslationTextComponent("ability." + this.ability + ""));
        target.setTempAbility(AbilityRegistry.getAbility(this.ability).get());
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        ArrayList<PixelmonWrapper> allies = pw.getTeamPokemon();
        for (PixelmonWrapper target : userChoice.targets) {
            Ability targetAbility = target.getBattleAbility(false);
            boolean negativeAbility = targetAbility.isNegativeAbility();
            boolean allied = allies.contains(target);
            if (allied && negativeAbility) {
                userChoice.raiseWeight(40.0f);
                continue;
            }
            if (allied || negativeAbility) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

