/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.value;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.api.rules.PropertyValue;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;

public class ClausesValue
implements PropertyValue<Set<BattleClause>> {
    private Set<BattleClause> value;

    public ClausesValue(Set<BattleClause> value) {
        this.value = value;
    }

    @Override
    public Set<BattleClause> get() {
        return this.value;
    }

    @Override
    public void update(Set<BattleClause> integer) {
        this.value = integer;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.value.size());
        Iterator<BattleClause> clauses = this.value.iterator();
        for (int i = 0; i < this.value.size(); ++i) {
            buffer.func_180714_a(clauses.next().getID());
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<String> badClauses = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String clause = buffer.func_218666_n();
            if (!BattleClauseRegistry.hasClause(clause)) {
                badClauses.add(clause);
                continue;
            }
            this.value.add(BattleClauseRegistry.getClause(clause));
        }
        if (badClauses.size() > 0) {
            String error = "Unable to decode some BattleClauses properly - " + String.join((CharSequence)", ", badClauses.toArray(new String[0]));
            Pixelmon.LOGGER.error(error);
        }
    }

    @Override
    public void write(String key, CompoundNBT compound) {
        ListNBT clauses = new ListNBT();
        this.value.forEach(clause -> clauses.add((Object)StringNBT.func_229705_a_((String)clause.getID())));
        compound.func_218657_a(key, (INBT)clauses);
    }

    @Override
    public void read(String key, CompoundNBT compound) {
        ListNBT clauses = compound.func_150295_c(key, (int)StringNBT.func_229705_a_((String)"").func_74732_a());
        ArrayList<String> badClauses = new ArrayList<String>();
        for (INBT nbt : clauses) {
            if (!BattleClauseRegistry.hasClause(nbt.func_150285_a_())) {
                badClauses.add(nbt.func_150285_a_());
                continue;
            }
            this.value.add(BattleClauseRegistry.getClause(nbt.func_150285_a_()));
        }
        if (badClauses.size() > 0) {
            String error = "Unable to decode some BattleClauses properly - " + String.join((CharSequence)", ", badClauses.toArray(new String[0]));
            Pixelmon.LOGGER.error(error);
        }
    }
}

