/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PokemonHelper {
    public static boolean hasPermanentFormsOrPalettes(Pokemon pokemon) {
        if (!pokemon.getSpecies().getForms(PokemonHelper::isFormPermanent).isEmpty()) {
            return true;
        }
        return !pokemon.getGenderProperties().getPalettes(PokemonHelper::isSpecialPalette).isEmpty();
    }

    public static boolean isFormPermanent(Stats form) {
        return !form.isDefault() && !form.isTemporary();
    }

    public static boolean isSpecialPalette(PaletteProperties palette) {
        return !palette.is("none") && !palette.is("shiny");
    }

    public static IFormattableTextComponent getFullName(Pokemon pokemon) {
        return PokemonHelper.getFullName(pokemon, false);
    }

    public static IFormattableTextComponent getFullName(Pokemon pokemon, boolean useNickname) {
        StringTextComponent pokeTitle = new StringTextComponent("");
        if (!pokemon.isDefaultForm()) {
            pokeTitle = pokemon.getForm().getTranslatedName().func_230529_a_((ITextComponent)new StringTextComponent(" "));
        }
        if (!pokemon.isDefaultPalette()) {
            pokeTitle.func_230529_a_((ITextComponent)pokemon.getPalette().getTranslatedName()).func_230529_a_((ITextComponent)new StringTextComponent(" "));
        }
        if (useNickname) {
            pokeTitle.func_230529_a_(pokemon.getFormattedNickname());
        } else {
            pokeTitle.func_230529_a_((ITextComponent)pokemon.getTranslatedName());
        }
        return pokeTitle;
    }
}

