/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.trading;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.List;

public class PossibleTradeList {
    private transient List<TradePair> filteredAllPossibleTrades = Lists.newArrayList();
    private List<TradePair> allPossibleTrades = Lists.newArrayList();
    private static PossibleTradeList INSTANCE;
    private static String foundJson;

    public static void registerTrades(Gson gson, JsonElement element) {
        foundJson = element.toString();
        Pixelmon.LOGGER.info("Registering trades.");
        INSTANCE = (PossibleTradeList)gson.fromJson(element, PossibleTradeList.class);
        PossibleTradeList.INSTANCE.allPossibleTrades = Lists.newArrayList(PossibleTradeList.INSTANCE.allPossibleTrades);
        PossibleTradeList.filterDisabledGenerations();
    }

    public static String getFoundJson() {
        return foundJson;
    }

    private static void filterDisabledGenerations() {
        if (PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
            PossibleTradeList.INSTANCE.filteredAllPossibleTrades = Lists.newArrayList(PossibleTradeList.INSTANCE.allPossibleTrades);
        } else {
            PossibleTradeList.INSTANCE.filteredAllPossibleTrades = new ArrayList<TradePair>();
            for (TradePair s : Lists.newArrayList(PossibleTradeList.INSTANCE.allPossibleTrades)) {
                RegistryValue offer;
                RegistryValue request = s.exchange.getValue(SpeciesRequirement.class).orElse(null);
                if (request == null || (offer = (RegistryValue)s.offer.getValue(SpeciesRequirement.class).orElse(null)) == null || !PixelmonConfigProxy.getSpawning().isGenerationEnabled(((Species)request.getValueUnsafe()).getGeneration()) || !PixelmonConfigProxy.getSpawning().isGenerationEnabled(((Species)offer.getValueUnsafe()).getGeneration())) continue;
                PossibleTradeList.INSTANCE.filteredAllPossibleTrades.add(s);
            }
            if (PossibleTradeList.INSTANCE.filteredAllPossibleTrades.isEmpty()) {
                PossibleTradeList.INSTANCE.filteredAllPossibleTrades.add(new TradePair(PokemonSpecificationProxy.create("Magikarp"), PokemonSpecificationProxy.create("Magikarp")));
                if (PixelmonConfigProxy.getSpawning().getBlockedGenerations().size() == 9) {
                    Pixelmon.LOGGER.error("No valid trades could be registered with only 0 being enabled!");
                } else {
                    StringBuilder blockedGenerations = new StringBuilder();
                    for (int gen : PixelmonConfigProxy.getSpawning().getBlockedGenerations()) {
                        if (blockedGenerations.length() > 0) {
                            blockedGenerations.append(",");
                        }
                        blockedGenerations.append(gen);
                    }
                    Pixelmon.LOGGER.error("No valid trades could be registered with " + blockedGenerations + " being disabled!");
                }
            } else if (!PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
                Pixelmon.LOGGER.info("Registered NPC trades. Filtered " + (PossibleTradeList.INSTANCE.allPossibleTrades.size() - PossibleTradeList.INSTANCE.filteredAllPossibleTrades.size()) + " trades containing disabled generation pokemon!");
            }
        }
    }

    public static List<TradePair> getAllPossibleTrades() {
        if (PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
            return PossibleTradeList.INSTANCE.allPossibleTrades;
        }
        return PossibleTradeList.INSTANCE.filteredAllPossibleTrades;
    }

    public static TradePair getRandomTrade() {
        return CollectionHelper.getRandomElement(PossibleTradeList.getAllPossibleTrades());
    }
}

