/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageManager;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import com.pixelmonmod.pixelmon.blocks.tileentity.PCTileEntity;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;

public class StorageProxy {
    private static StorageManager storageManager;

    public static boolean hasImplementation() {
        return storageManager != null;
    }

    public static void setStorageManager(StorageManager storageManager) {
        StorageProxy.storageManager = storageManager;
    }

    public static StorageManager getStorageManager() {
        return storageManager;
    }

    public static StorageSaveScheduler getSaveScheduler() {
        return storageManager.getSaveScheduler();
    }

    public static StorageSaveAdapter getSaveAdapter() {
        return storageManager.getSaveAdapter();
    }

    public static PCStorage getPCForPlayer(UUID playerUUID) {
        return storageManager.getPCForPlayer(playerUUID);
    }

    public static PlayerPartyStorage getParty(UUID uuid) {
        return storageManager.getParty(uuid);
    }

    public static Iterable<PokemonStorage> getAllCachedStorages() {
        return storageManager.getAllCachedStorages();
    }

    public static void onStorageSaved(PokemonStorage storage) {
        storageManager.onStorageSaved(storage);
    }

    public static void clearAll() {
        storageManager.clearAll();
    }

    public static PCStorage getPC(ServerPlayerEntity player, PCTileEntity pc) {
        return storageManager.getPC(player, pc);
    }

    public static PCStorage getPCForPlayer(ServerPlayerEntity player) {
        return storageManager.getPCForPlayer(player);
    }

    public static PlayerPartyStorage getParty(ServerPlayerEntity player) {
        return storageManager.getParty(player);
    }

    public static PokemonStorage getStorage(ServerPlayerEntity player, StoragePosition position) {
        return storageManager.getStorage(player, position);
    }

    public static Pokemon getPokemon(ServerPlayerEntity player, StoragePosition position) {
        return storageManager.getPokemon(player, position);
    }

    public static void initializePCForPlayer(ServerPlayerEntity player, PCStorage pc) {
        storageManager.initializePCForPlayer(player, pc);
    }
}

