/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.conditions;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnTime;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class SpawnCondition {
    public static Class<? extends SpawnCondition> targetedSpawnCondition = SpawnCondition.class;
    public ArrayList<WorldTime> times = null;
    private ArrayList<SpawnTime> realWorldSpawnTimes = null;
    public transient Set<WeatherType> cachedWeathers = null;
    public transient Set<Block> cachedBaseBlocks = Sets.newHashSet();
    public transient Set<Block> cachedNeededNearbyBlocks = Sets.newHashSet();
    public transient Set<ResourceLocation> biomes = Sets.newHashSet();
    public transient Set<ResourceLocation> cachedDimensions = Sets.newHashSet();
    private ArrayList<String> weathers = null;
    private ArrayList<String> stringBiomes = null;
    private ArrayList<String> baseBlocks = null;
    private ArrayList<String> neededNearbyBlocks = null;
    private ArrayList<String> partyHeadSpecies = null;
    public String tag = null;
    public Boolean seesSky = null;
    public Float temperature = null;
    public ArrayList<String> dimensions = null;
    public ArrayList<String> structures = null;
    public Integer minX = null;
    public Integer maxX = null;
    public Integer minY = null;
    public Integer maxY = null;
    public Integer minZ = null;
    public Integer maxZ = null;
    public Integer moonPhase = null;
    public Integer minLightLevel = null;
    public Integer maxLightLevel = null;
    private boolean disabled = false;
    static ArrayList<WorldTime> currentTimes = new ArrayList();

    public void onExport() {
        this.stringBiomes = new ArrayList();
        for (Block block : this.cachedBaseBlocks) {
            this.baseBlocks.add(block.getRegistryName().toString());
        }
        for (Block block : this.cachedNeededNearbyBlocks) {
            this.neededNearbyBlocks.add(block.getRegistryName().toString());
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void cacheRegistry(RegistryKey<? extends Registry<T>> key, ArrayList<String> from, Collection<T> to, HashMap<String, Set<T>> categories) {
        if (from == null) {
            return;
        }
        block0: for (String id : from) {
            if (categories.containsKey(id)) {
                to.addAll((Collection)categories.get(id));
                continue;
            }
            ForgeRegistry registry1 = RegistryManager.ACTIVE.getRegistry(key);
            IForgeRegistryEntry value = registry1.getValue(ResourceLocationHelper.of(id));
            if (value != null) {
                to.add(value);
                continue;
            }
            for (Map.Entry entry : registry1.getEntries()) {
                if (!((RegistryKey)entry.getKey()).func_240901_a_().toString().equalsIgnoreCase(id) && !((RegistryKey)entry.getKey()).func_240901_a_().func_110623_a().equalsIgnoreCase(id)) continue;
                to.add(entry.getValue());
                continue block0;
            }
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void cacheRegistry(RegistryKey<? extends Registry<T>> key, ArrayList<String> from, Collection<ResourceLocation> to, HashMap<String, Set<T>> categories, Function<T, ResourceLocation> mapper) {
        if (from == null) {
            return;
        }
        block0: for (String id : from) {
            if (categories.containsKey(id)) {
                for (IForgeRegistryEntry t : categories.get(id)) {
                    to.add(mapper.apply(t));
                }
                continue;
            }
            ForgeRegistry registry1 = RegistryManager.ACTIVE.getRegistry(key);
            IForgeRegistryEntry value = registry1.getValue(ResourceLocationHelper.of(id));
            if (value != null) {
                to.add(mapper.apply(value));
                continue;
            }
            for (Map.Entry entry : registry1.getEntries()) {
                if (!((RegistryKey)entry.getKey()).func_240901_a_().toString().equalsIgnoreCase(id) && !((RegistryKey)entry.getKey()).func_240901_a_().func_110623_a().equalsIgnoreCase(id)) continue;
                to.add(mapper.apply((IForgeRegistryEntry)entry.getValue()));
                continue block0;
            }
        }
    }

    public void onImport() {
        if (this.stringBiomes == null) {
            this.stringBiomes = new ArrayList();
        }
        if (this.weathers != null && !this.weathers.isEmpty()) {
            this.cachedWeathers = EnumSet.noneOf(WeatherType.class);
            for (String weather : this.weathers) {
                this.cachedWeathers.add(WeatherType.valueOf(weather.toUpperCase(Locale.ROOT)));
            }
        }
        SpawnCondition.cacheRegistry(Registry.field_239720_u_, this.stringBiomes, this.biomes, BetterSpawnerConfig.INSTANCE.cachedBiomeCategories, IForgeRegistryEntry::getRegistryName);
        if (this.biomes.isEmpty() && !this.stringBiomes.isEmpty()) {
            this.disabled = true;
        }
        SpawnCondition.cacheRegistry(Registry.field_239711_l_, this.baseBlocks, this.cachedBaseBlocks, BetterSpawnerConfig.INSTANCE.cachedBlockCategories);
        SpawnCondition.cacheRegistry(Registry.field_239711_l_, this.neededNearbyBlocks, this.cachedNeededNearbyBlocks, BetterSpawnerConfig.INSTANCE.cachedBlockCategories);
        if (this.dimensions != null) {
            for (String dimension : this.dimensions) {
                this.cachedDimensions.add(ResourceLocationHelper.of(dimension));
            }
        }
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        if (this.disabled) {
            return false;
        }
        if (!this.doesHeadOfPartyMatch(spawnLocation)) {
            return false;
        }
        if (!(this.tag == null || spawnInfo.tags != null && spawnInfo.tags.contains(this.tag))) {
            return false;
        }
        if (this.seesSky != null && this.seesSky != spawnLocation.seesSky) {
            return false;
        }
        if (this.temperature != null && this.temperature.floatValue() != spawnLocation.biome.func_242445_k()) {
            return false;
        }
        if (!this.cachedDimensions.isEmpty() && !this.cachedDimensions.contains(spawnLocation.location.world.func_234923_W_().func_240901_a_())) {
            return false;
        }
        if (this.minX != null && spawnLocation.location.pos.func_177958_n() < this.minX) {
            return false;
        }
        if (this.maxX != null && spawnLocation.location.pos.func_177958_n() > this.maxX) {
            return false;
        }
        if (this.minY != null && spawnLocation.location.pos.func_177956_o() < this.minY) {
            return false;
        }
        if (this.maxY != null && spawnLocation.location.pos.func_177956_o() > this.maxY) {
            return false;
        }
        if (this.minZ != null && spawnLocation.location.pos.func_177952_p() < this.minZ) {
            return false;
        }
        if (this.maxZ != null && spawnLocation.location.pos.func_177952_p() > this.maxZ) {
            return false;
        }
        if (this.weathers != null && !this.weathers.isEmpty() && !this.cachedWeathers.contains((Object)WeatherType.get(spawnLocation.location.world))) {
            return false;
        }
        if (!(((ServerWorld)spawnLocation.location.world).func_72863_F().func_201711_g() instanceof FlatChunkGenerator || this.biomes == null || this.biomes.isEmpty() || this.biomes.contains(spawnLocation.biome.getRegistryName()))) {
            return false;
        }
        if (!this.doesRealTimeFit()) {
            return false;
        }
        if (!this.doesWorldTimeFit(spawnLocation.location.world)) {
            return false;
        }
        if (this.moonPhase != null && spawnLocation.location.world.func_230315_m_().func_236035_c_(spawnLocation.location.world.func_241851_ab()) != this.moonPhase.intValue()) {
            return false;
        }
        if (this.minLightLevel != null && spawnLocation.light < this.minLightLevel) {
            return false;
        }
        if (this.maxLightLevel != null && spawnLocation.light > this.maxLightLevel) {
            return false;
        }
        if (this.cachedBaseBlocks != null && !this.cachedBaseBlocks.isEmpty() && !this.cachedBaseBlocks.contains(spawnLocation.baseBlock)) {
            return false;
        }
        if (this.cachedNeededNearbyBlocks != null && !this.cachedNeededNearbyBlocks.isEmpty() && !CollectionHelper.containsAll(spawnLocation.uniqueSurroundingBlocks, this.cachedNeededNearbyBlocks)) {
            return false;
        }
        if (this.structures != null && !this.structures.isEmpty() && spawnLocation.location.world instanceof ServerWorld) {
            ServerWorld ws = (ServerWorld)spawnLocation.location.world;
            boolean inStructure = false;
            for (String structure : this.structures) {
                if (!WorldHelper.insideStructure(ws, structure, (BlockPos)spawnLocation.location.pos)) continue;
                inStructure = true;
            }
            if (!inStructure) {
                return false;
            }
        }
        return true;
    }

    private boolean doesHeadOfPartyMatch(SpawnLocation spawnLocation) {
        if (this.partyHeadSpecies == null || this.partyHeadSpecies.isEmpty()) {
            return true;
        }
        if (!(spawnLocation.cause instanceof ServerPlayerEntity)) {
            return false;
        }
        PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)spawnLocation.cause);
        Pokemon headOfParty = party.get(0);
        if (headOfParty == null) {
            return false;
        }
        return this.partyHeadSpecies.contains(headOfParty.getSpecies().getName());
    }

    private boolean doesWorldTimeFit(World world) {
        if (this.times == null || this.times.isEmpty()) {
            return true;
        }
        List<WorldTime> times = WorldTime.getCurrent(world);
        for (int i = 0; i < times.size(); ++i) {
            WorldTime time = times.get(i);
            if (!this.times.contains(time)) continue;
            return true;
        }
        return false;
    }

    private boolean doesRealTimeFit() {
        if (this.realWorldSpawnTimes == null || this.realWorldSpawnTimes.isEmpty()) {
            return true;
        }
        for (SpawnTime spawnTime : this.realWorldSpawnTimes) {
            if (!spawnTime.matches()) continue;
            return true;
        }
        return false;
    }
}

