/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerTrackingCheckSpawns
implements CheckSpawns {
    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSource sender, List<String> arguments) {
        if (!(spawner instanceof PlayerTrackingSpawner)) {
            CheckSpawns.getDefault().checkSpawns(spawner, sender, arguments);
        } else {
            PlayerTrackingSpawner pSpawner = (PlayerTrackingSpawner)spawner;
            ServerPlayerEntity player = pSpawner.getTrackedPlayer();
            if (player == null) {
                sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "pixelmon.command.general.invalidplayer"), false);
                return;
            }
            BlockCollection blocks = spawner.getTrackedBlockCollection((Entity)player, 0.0f, 0.0f, pSpawner.horizontalSliceRadius, pSpawner.verticalSliceRadius, 0, 0).join();
            ArrayList<SpawnLocation> spawnLocations = pSpawner.spawnLocationCalculator.calculateSpawnableLocations(blocks);
            for (String argument : arguments) {
                if (!argument.equalsIgnoreCase("specific")) continue;
                spawnLocations.removeIf(spawnLocation -> !spawnLocation.location.pos.equals((Object)player.func_233580_cy_()));
                if (!spawnLocations.isEmpty()) break;
                sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.midairorinvalid"), false);
                return;
            }
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            for (SpawnLocation spawnLocation2 : spawnLocations) {
                List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation2);
                if (spawns.isEmpty()) continue;
                possibleSpawns.put(spawnLocation2, spawns);
            }
            ServerLifecycleHooks.getCurrentServer().execute(() -> {
                Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
                List<IFormattableTextComponent> messages = this.generateMessages(percentages, arguments);
                messages.add(0, TextHelper.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
                for (IFormattableTextComponent message : messages) {
                    sender.func_197030_a((ITextComponent)message, false);
                }
            });
        }
    }
}

