/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.AlwaysModelPredicate;
import com.pixelmonmod.pixelmon.client.models.ModelFactoryFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ModelLocatorTypeAdapter
implements JsonSerializer<ModelLocator>,
JsonDeserializer<ModelLocator> {
    private static final ModelLocator DEFAULTS;
    private static final Field[] FIELDS;

    public ModelLocator deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        ModelFactoryFactory factory = ModelFactoryFactory.valueOf(object.get("factoryType").getAsString());
        ModelPredicate predicate = this.getPredicate(object);
        ArrayList pqc = Lists.newArrayList();
        for (JsonElement str : object.get("pqc").getAsJsonArray()) {
            if (str.isJsonPrimitive()) {
                pqc.add(Pair.of((Object)str.getAsString(), (Object)str.getAsString()));
                continue;
            }
            JsonObject jsonObject = str.getAsJsonObject();
            pqc.add(Pair.of((Object)jsonObject.get("resource").getAsString(), (Object)jsonObject.get("fallback").getAsString()));
        }
        ModelLocator locator = new ModelLocator(factory, predicate, pqc);
        for (Field field : FIELDS) {
            String name;
            if (!field.getType().equals(Float.TYPE) || !object.has(name = field.getName())) continue;
            field.setAccessible(true);
            try {
                field.set(locator, Float.valueOf(object.get(name).getAsFloat()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(false);
        }
        return locator;
    }

    private ModelPredicate getPredicate(JsonObject object) {
        if (!object.has("modelPredicate")) {
            return AlwaysModelPredicate.INSTANCE;
        }
        DataResult modelPredicate = ModelPredicate.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("modelPredicate"));
        ModelPredicate result = modelPredicate.result().orElse(null);
        if (result != null) {
            return result;
        }
        Pixelmon.LOGGER.error("There was an error reading model predicate: {}", (Object)((DataResult.PartialResult)modelPredicate.error().get()).message());
        return AlwaysModelPredicate.INSTANCE;
    }

    public JsonElement serialize(ModelLocator src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonArray pqc = new JsonArray();
        for (Pair<String, String> str : src.getPQCs()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("resource", (String)str.getFirst());
            jsonObject.addProperty("fallback", (String)str.getSecond());
            pqc.add((JsonElement)jsonObject);
        }
        object.addProperty("factoryType", src.getFactoryType().name());
        object.add("pqc", (JsonElement)pqc);
        for (Field field : FIELDS) {
            String name;
            if (!field.getType().equals(Float.TYPE) || !object.has(name = field.getName())) continue;
            field.setAccessible(true);
            try {
                float valueSrc = ((Float)field.get(src)).floatValue();
                float valueDefault = ((Float)field.get(DEFAULTS)).floatValue();
                if (valueSrc != valueDefault) {
                    object.addProperty(name, (Number)Float.valueOf(valueSrc));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(false);
        }
        return object;
    }

    static {
        FIELDS = ModelLocator.class.getDeclaredFields();
        DEFAULTS = FMLEnvironment.dist == Dist.CLIENT ? new ModelLocator(ModelFactoryFactory.NORMAL, null, Lists.newArrayList()) : null;
    }
}

