/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.boss;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.WeightedSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class DropSet {
    private final double chance;
    private final int quantity;
    private final WeightedSet<Drop> drops;

    public DropSet(double chance, int quantity, WeightedSet<Drop> drops) {
        this.chance = chance;
        this.quantity = quantity;
        this.drops = drops;
    }

    public DropSet(JsonObject json, JsonDeserializationContext ctx) {
        this.chance = json.get("chance").getAsDouble();
        this.quantity = json.get("quantity").getAsInt();
        this.drops = WeightedSet.newWeightedSet(new Object[0]);
        for (JsonElement element : json.getAsJsonArray("drops")) {
            Drop drop = new Drop(element.getAsJsonObject(), ctx);
            this.drops.add(drop.getWeight(), drop);
        }
    }

    public DropSet(PacketBuffer buf) {
        this.chance = buf.readDouble();
        this.quantity = buf.readInt();
        int numberOfDrops = buf.readInt();
        this.drops = WeightedSet.newWeightedSet(new Object[0]);
        for (int i = numberOfDrops; i > 0; --i) {
            Drop d = new Drop(buf);
            this.drops.add(d.weight, d);
        }
    }

    public Set<Drop> getDrops() {
        HashSet drops = Sets.newHashSet();
        if (!this.drops.isEffectivelyEmpty() && RandomHelper.getRandomChance(this.chance)) {
            for (int i = 0; i < this.quantity; ++i) {
                drops.add(this.drops.get());
            }
        }
        return drops;
    }

    public void toBuffer(PacketBuffer buf) {
        buf.writeDouble(this.chance);
        buf.writeInt(this.quantity);
        buf.writeInt(this.drops.size());
        Iterator<Drop> dropIterator = this.drops.iterator();
        while (dropIterator.hasNext()) {
            Drop drop = dropIterator.next();
            drop.toBuffer(buf);
        }
    }

    public static class Drop {
        private final int weight;
        private final String name;
        private final ItemStack item;
        private final String[] commands;
        private final boolean ephemeral;

        public Drop(int weight, String name, ItemStack item, boolean ephemeral, String ... commands) {
            this.weight = weight;
            this.name = name;
            this.item = item;
            this.ephemeral = ephemeral;
            this.commands = commands;
        }

        public Drop(JsonObject json, JsonDeserializationContext ctx) {
            ItemStack item;
            this.weight = json.get("weight").getAsInt();
            this.name = json.get("name").getAsString();
            String itemString = json.get("item").getAsString();
            if (itemString.contains("{")) {
                try {
                    item = ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)itemString));
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to read item NBT in boss drop: " + itemString);
                    item = ItemStack.field_190927_a;
                }
            } else {
                try {
                    item = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(itemString)));
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to read item in boss drop: " + itemString);
                    item = ItemStack.field_190927_a;
                }
            }
            this.item = item;
            JsonArray commands = json.getAsJsonArray("commands");
            this.commands = new String[commands.size()];
            int i = 0;
            for (JsonElement command : commands) {
                this.commands[i++] = command.getAsString();
            }
            this.ephemeral = json.get("ephemeral").getAsBoolean();
        }

        public Drop(PacketBuffer buf) {
            this.weight = buf.readInt();
            this.name = buf.func_218666_n();
            this.item = buf.func_150791_c();
            if (!this.name.isEmpty()) {
                this.item.func_200302_a((ITextComponent)new StringTextComponent(this.name));
            }
            int commandsLength = buf.readInt();
            this.commands = new String[commandsLength];
            for (int i = 0; i < commandsLength; ++i) {
                this.commands[i] = buf.func_218666_n();
            }
            this.ephemeral = buf.readBoolean();
        }

        public void toBuffer(PacketBuffer buf) {
            buf.writeInt(this.weight);
            buf.func_180714_a(this.name);
            buf.func_150788_a(this.item);
            buf.writeInt(this.commands.length);
            for (String command : this.commands) {
                buf.func_180714_a(command);
            }
            buf.writeBoolean(this.ephemeral);
        }

        public int getWeight() {
            return this.weight;
        }

        public String getName() {
            return this.name == null || this.name.isEmpty() ? this.item.func_151000_E().getString() : this.name;
        }

        public ItemStack getDisplayItem() {
            ItemStack stack = this.item.func_77946_l();
            if (!this.name.isEmpty()) {
                stack.func_200302_a((ITextComponent)new StringTextComponent(this.getName()));
            }
            return stack;
        }

        public void drop(ServerPlayerEntity player, Vector3d pos) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (this.ephemeral) {
                this.give(player);
            } else {
                server.execute(() -> player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), this.item.func_77946_l())));
            }
        }

        public void give(ServerPlayerEntity player) {
            ItemStack item;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (!this.ephemeral && !player.func_191521_c(item = this.item.func_77946_l())) {
                player.func_146097_a(item, false, false);
            }
            for (String command : this.commands) {
                server.func_195571_aL().func_197059_a(server.func_195573_aM(), command.replace("@p", player.func_200200_C_().getString()));
            }
        }
    }
}

