/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;

public class NeutralizingGas
extends AbstractAbility {
    private static final List<String> INVALID_ABILITIES = Lists.newArrayList((Object[])new String[]{"NeutralizingGas", "Multitype", "StanceChange", "Schooling", "Comatose", "ShieldsDown", "Disguise", "RKSSystem", "BattleBond", "PowerConstruct", "AsOne", "ZenMode", "GulpMissile", "IceFace"});

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        newPokemon.bc.sendToAll("pixelmon.abilities.neutralizinggas", new Object[0]);
    }

    @Override
    public void onSelfFaint(PixelmonWrapper pokemon, PixelmonWrapper source) {
        this.triggerOtherSwitchInAbilities(pokemon, pokemon.bc);
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.triggerOtherSwitchInAbilities(oldPokemon, oldPokemon.bc);
    }

    private void triggerOtherSwitchInAbilities(PixelmonWrapper pw, BattleController bc) {
        for (PixelmonWrapper opw : bc.getActivePokemon()) {
            if (pw == opw) continue;
            opw.getBattleAbility(false).applySwitchInEffect(opw);
        }
    }

    public static boolean isAbilityDisabled(Ability ability) {
        return !INVALID_ABILITIES.contains(ability.getName()) && ability.canBeDisabled();
    }
}

