/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;

public class Forecast
extends AbstractAbility {
    @Override
    public void onWeatherChange(PixelmonWrapper pw, Weather weather) {
        if (pw.getSpecies().is(PixelmonSpecies.CASTFORM)) {
            if (pw.bc.simulateMode) {
                return;
            }
            StatusType weatherType = weather == null ? StatusType.None : weather.type;
            String form = PixelmonForms.NONE;
            switch (weatherType) {
                case Rainy: {
                    form = "rain";
                    break;
                }
                case Sunny: {
                    form = "sun";
                    break;
                }
                case Snow: 
                case Hail: {
                    form = "ice";
                    break;
                }
            }
            if (!pw.getForm().getName().equals(form)) {
                pw.setForm(form);
                pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
            }
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.resetForm(newPokemon);
        this.onWeatherChange(newPokemon, newPokemon.bc.globalStatusController.getWeather());
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        this.resetForm(pw);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.onWeatherChange(pokemon, null);
    }

    private void resetForm(PixelmonWrapper pw) {
        if (pw.bc.simulateMode) {
            return;
        }
        if (!pw.getForm().getName().equals("base")) {
            pw.setForm("base");
        }
    }
}

