/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonItemStack {
    public String itemID = "minecraft:stone";
    public Integer quantity = null;
    public String nbt = null;
    public Float percentChance = null;
    private transient ItemStack stack = null;

    public JsonItemStack() {
    }

    public JsonItemStack(Item item) {
        this.itemID = item.getRegistryName().toString();
    }

    public ItemStack getItemStack() {
        if (this.stack == null) {
            Item item = null;
            if (this.itemID.contains(":")) {
                ResourceLocation resourceLocation = ResourceLocationHelper.of(this.itemID.split(":")[0], this.itemID.split(":")[1]);
                item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item == null) {
                    Pixelmon.LOGGER.error("Invalid item ID found in SpawnInfo: " + this.itemID + " is not a recognized item.");
                    return ItemStack.field_190927_a;
                }
            } else {
                ArrayList matchingItems = new ArrayList();
                ForgeRegistries.ITEMS.forEach(testItem -> {
                    if (testItem.getRegistryName().func_110623_a().equalsIgnoreCase(this.itemID)) {
                        matchingItems.add(testItem);
                    }
                });
                if (matchingItems.isEmpty()) {
                    Pixelmon.LOGGER.error("Invalid item ID found in SpawnInfo: " + this.itemID + " is not a recognized item.");
                    return ItemStack.field_190927_a;
                }
                if (matchingItems.size() > 1) {
                    Pixelmon.LOGGER.error("Duplicate items found for item ID in SpawnInfo: " + this.itemID + ". Prefix this id with the resource domain, such as: 'minecraft:'");
                    return ItemStack.field_190927_a;
                }
                item = (Item)matchingItems.get(0);
            }
            this.stack = new ItemStack((IItemProvider)item, this.quantity == null ? 1 : this.quantity);
            CompoundNBT deserializedNBT = null;
            if (this.nbt != null) {
                try {
                    deserializedNBT = JsonToNBT.func_180713_a((String)this.nbt);
                }
                catch (CommandSyntaxException e) {
                    Pixelmon.LOGGER.error("Bad NBT: " + this.nbt);
                    e.printStackTrace();
                }
            }
            if (deserializedNBT != null) {
                if (this.stack.func_77978_p() == null) {
                    this.stack.func_77982_d(new CompoundNBT());
                }
                this.stack.func_77982_d(deserializedNBT);
            }
        }
        return this.stack.func_77946_l();
    }

    public static ItemStack choose(List<JsonItemStack> stacks) {
        float chosenPercentage;
        float percentSum = 0.0f;
        for (JsonItemStack stack : stacks) {
            if (stack.percentChance == null || !(stack.percentChance.floatValue() > 0.0f)) continue;
            if (percentSum + stack.percentChance.floatValue() > 100.0f) {
                Pixelmon.LOGGER.warn("Itemstack percent chance is above 100%. Overflowed to: " + (percentSum + stack.percentChance.floatValue()));
                break;
            }
            percentSum += stack.percentChance.floatValue();
        }
        if ((chosenPercentage = RandomHelper.getRandomNumberBetween(0.0f, 100.0f)) > percentSum) {
            return null;
        }
        percentSum = 0.0f;
        for (JsonItemStack stack : stacks) {
            if (stack.percentChance == null || !(stack.percentChance.floatValue() > 0.0f) || !((percentSum += stack.percentChance.floatValue()) >= chosenPercentage)) continue;
            return stack.getItemStack();
        }
        return null;
    }
}

