/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.npc;

import com.google.common.collect.ImmutableMap;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleResults;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class NPCEvent
extends Event {
    public NPCEntity npc;
    public EnumNPCType type;
    public PlayerEntity player;

    protected NPCEvent() {
    }

    protected NPCEvent(NPCEntity npc, EnumNPCType type, PlayerEntity player) {
        this.npc = npc;
        this.type = type;
        this.player = player;
    }

    public static class EndBattle
    extends NPCEvent {
        public final BattleController bc;
        public final BattleEndCause cause;
        public final boolean abnormal;
        private final ImmutableMap<BattleParticipant, BattleResults> results;

        public EndBattle(BattleController bc, BattleEndCause cause, boolean abnormal, Map<BattleParticipant, BattleResults> results) {
            this.results = ImmutableMap.copyOf(results);
            this.npc = this.getNPCParticipant().trainer;
            this.player = this.getPlayerParticipant().player;
            this.type = EnumNPCType.Trainer;
            this.bc = bc;
            this.cause = cause;
            this.abnormal = abnormal;
        }

        public PlayerParticipant getPlayerParticipant() {
            for (BattleParticipant bp : this.results.keySet()) {
                if (!(bp instanceof PlayerParticipant)) continue;
                return (PlayerParticipant)bp;
            }
            return null;
        }

        public TrainerParticipant getNPCParticipant() {
            for (BattleParticipant bp : this.results.keySet()) {
                if (!(bp instanceof TrainerParticipant)) continue;
                return (TrainerParticipant)bp;
            }
            return null;
        }

        public BattleResults getPlayerResults() {
            return (BattleResults)((Object)this.results.get((Object)this.getPlayerParticipant()));
        }

        public BattleResults getNPCResults() {
            return (BattleResults)((Object)this.results.get((Object)this.getNPCParticipant()));
        }
    }

    @Cancelable
    public static class StartBattle
    extends NPCEvent {
        private final List<BattleParticipant> participants;

        public StartBattle(List<BattleParticipant> participants) {
            this.participants = participants;
            this.npc = this.getNPCParticipant().trainer;
            this.player = this.getPlayerParticipant().player;
            this.type = EnumNPCType.Trainer;
        }

        public PlayerParticipant getPlayerParticipant() {
            for (BattleParticipant bp : this.participants) {
                if (!(bp instanceof PlayerParticipant)) continue;
                return (PlayerParticipant)bp;
            }
            return null;
        }

        public TrainerParticipant getNPCParticipant() {
            for (BattleParticipant bp : this.participants) {
                if (!(bp instanceof TrainerParticipant)) continue;
                return (TrainerParticipant)bp;
            }
            return null;
        }
    }

    @Cancelable
    public static class Interact
    extends NPCEvent {
        public Interact(NPCEntity npc, EnumNPCType type, PlayerEntity player) {
            super(npc, type, player);
        }
    }
}

