/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.blocks;

import com.pixelmonmod.pixelmon.blocks.TumblestoneBlock;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class TumblestoneBlockEvent
extends Event {
    private final World level;
    private final BlockState state;
    private final BlockPos pos;

    protected TumblestoneBlockEvent(World level, BlockState state, BlockPos pos) {
        this.level = level;
        this.state = state;
        this.pos = pos;
    }

    public World getWorld() {
        return this.level;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static class PostCooldownEnd
    extends TumblestoneBlockEvent {
        private final boolean success;
        private final float chance;

        public PostCooldownEnd(World level, BlockState state, BlockPos pos, boolean success, float chance) {
            super(level, state, pos);
            this.success = success;
            this.chance = chance;
        }

        public float getChance() {
            return this.chance;
        }

        public boolean wasSuccessful() {
            return this.success;
        }
    }

    @Cancelable
    public static class PreCooldownEnd
    extends TumblestoneBlockEvent {
        private float chance;

        public PreCooldownEnd(World level, BlockState state, BlockPos pos, float chance) {
            super(level, state, pos);
            this.chance = chance;
        }

        public float getChance() {
            return this.chance;
        }

        public void setChance(float chance) {
            this.chance = chance;
        }
    }

    public static class PostBlockBroke
    extends TumblestoneBlockEvent {
        private final PlayerEntity player;
        private final ItemStack itemStack;
        private final List<ItemStack> drops;

        public PostBlockBroke(World level, BlockState state, BlockPos pos, PlayerEntity player, ItemStack itemStack, List<ItemStack> drops) {
            super(level, state, pos);
            this.player = player;
            this.itemStack = itemStack;
            this.drops = drops;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public List<ItemStack> getDrops() {
            return this.drops;
        }
    }

    @Cancelable
    public static class PreBlockBroke
    extends TumblestoneBlockEvent {
        private final PlayerEntity player;
        private final ItemStack itemStack;
        private final List<ItemStack> drops;

        public PreBlockBroke(World level, BlockState state, BlockPos pos, PlayerEntity player, ItemStack itemStack, List<ItemStack> drops) {
            super(level, state, pos);
            this.player = player;
            this.itemStack = itemStack;
            this.drops = drops;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public List<ItemStack> getDrops() {
            return this.drops;
        }

        public void addDrops(List<ItemStack> items) {
            this.drops.addAll(items);
        }

        public void clearDrops() {
            this.drops.clear();
        }
    }

    public static class PostGrow
    extends TumblestoneBlockEvent {
        private final float chance;

        public PostGrow(World level, BlockState state, BlockPos pos, float chance) {
            super(level, state, pos);
            this.chance = chance;
        }

        public float getChance() {
            return this.chance;
        }

        public boolean isFullyGrown() {
            return (Integer)this.getState().func_177229_b((Property)TumblestoneBlock.AGE) == 5;
        }
    }

    @Cancelable
    public static class PreGrow
    extends TumblestoneBlockEvent {
        private float chance;

        public PreGrow(World level, BlockState state, BlockPos pos, float chance) {
            super(level, state, pos);
            this.chance = chance;
        }

        public float getChance() {
            return this.chance;
        }

        public void setChance(float chance) {
            this.chance = chance;
        }
    }

    public static class PostBlockDestroy
    extends TumblestoneBlockEvent {
        private final PlayerEntity player;
        private final ItemStack item;

        public PostBlockDestroy(World level, BlockState state, BlockPos pos, PlayerEntity player, ItemStack item) {
            super(level, state, pos);
            this.player = player;
            this.item = item;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }

    @Cancelable
    public static class PreBlockDestroy
    extends TumblestoneBlockEvent {
        private final PlayerEntity player;
        private final ItemStack item;

        public PreBlockDestroy(World level, BlockState state, BlockPos pos, PlayerEntity player, ItemStack item) {
            super(level, state, pos);
            this.player = player;
            this.item = item;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

