/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import java.util.Arrays;
import java.util.List;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/raids.yml")
public class RaidsConfig
extends AbstractYamlConfig {
    private List<Float> raidShinyChances = Arrays.asList(Float.valueOf(4096.0f), Float.valueOf(4096.0f), Float.valueOf(2048.0f), Float.valueOf(1024.0f), Float.valueOf(1024.0f));
    private List<Float> raidHAChances = Arrays.asList(Float.valueOf(150.0f), Float.valueOf(125.0f), Float.valueOf(100.0f), Float.valueOf(75.0f), Float.valueOf(50.0f));
    private List<Float> raidGigantamaxFactorChances = Arrays.asList(Float.valueOf(512.0f), Float.valueOf(512.0f), Float.valueOf(512.0f), Float.valueOf(256.0f), Float.valueOf(128.0f));
    private float denSpawnChanceModifier = 0.3f;
    private int denRespawnTime = 100;
    private float denRespawnChance = 0.75f;
    private List<Integer> denStarWeights = Arrays.asList(19, 12, 9, 3, 1);
    private boolean raidHaveLegendaries = true;
    private boolean raidHaveUltraBeasts = true;
    private List<Boolean> raidMasterBallBlock = Arrays.asList(false, false, false, false, false);
    private List<Boolean> raidOnlyLeaderCanCatch = Arrays.asList(false, false, false, false, false);
    private List<String> raidBlacklist = Arrays.asList("MissingNo");
    private boolean raidDensBreakable = true;

    public float getRaidShinyRate(int stars) {
        int ordinal = stars - 1;
        if (this.raidShinyChances.size() > ordinal) {
            return this.raidShinyChances.get(ordinal).floatValue();
        }
        return PixelmonConfigProxy.getSpawning().getShinyRate();
    }

    public float getRaidHARate(int stars) {
        int ordinal = stars - 1;
        if (this.raidHAChances.size() > ordinal) {
            return this.raidHAChances.get(ordinal).floatValue();
        }
        return PixelmonConfigProxy.getSpawning().getHiddenAbilityRate();
    }

    public float getRaidGigantamaxFactorRate(int stars) {
        int ordinal = stars - 1;
        if (this.raidGigantamaxFactorChances.size() > ordinal) {
            return this.raidGigantamaxFactorChances.get(ordinal).floatValue();
        }
        return PixelmonConfigProxy.getSpawning().getGigantamaxFactorRate();
    }

    public int getRaidDropCount(int stars) {
        int ordinal = stars - 1;
        if (PixelmonConfigProxy.getGeneral().getDrops().getDenStarDrops().size() > ordinal) {
            return PixelmonConfigProxy.getGeneral().getDrops().getDenStarDrops().get(ordinal);
        }
        return 5;
    }

    public float getDenSpawnChanceModifier() {
        return this.denSpawnChanceModifier;
    }

    public int getDenRespawnTime() {
        return this.denRespawnTime;
    }

    public float getDenRespawnChance() {
        return this.denRespawnChance;
    }

    public List<Integer> getDenStarWeights() {
        return this.denStarWeights;
    }

    public boolean isRaidHaveLegendaries() {
        return this.raidHaveLegendaries;
    }

    public boolean isRaidHaveUltraBeasts() {
        return this.raidHaveUltraBeasts;
    }

    public boolean getRaidCanUseMaster(int stars) {
        if (stars == -1) {
            return false;
        }
        int ordinal = stars - 1;
        if (this.raidMasterBallBlock.size() > ordinal) {
            return this.raidMasterBallBlock.get(ordinal) == false;
        }
        return true;
    }

    public boolean getRaidCanAllCatch(int stars) {
        if (stars == -1) {
            return false;
        }
        int ordinal = stars - 1;
        if (this.raidOnlyLeaderCanCatch.size() > ordinal) {
            return this.raidOnlyLeaderCanCatch.get(ordinal) == false;
        }
        return true;
    }

    public List<String> getRaidBlacklist() {
        return this.raidBlacklist;
    }

    public boolean isRaidDensBreakable() {
        return this.raidDensBreakable;
    }
}

