/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.ui.ConfigSetting;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.util.helpers.JavaHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/config.yml")
public class GeneralConfig
extends AbstractYamlConfig {
    private double startingBalance = 0.0;
    private boolean awardTokens = false;
    private boolean allowPokemonNicknames = true;
    private boolean allowVanillaMobs = false;
    private boolean allowCaptureOutsideBattle = true;
    private boolean allowRandomPokemonToBeLegendary = true;
    @ConfigSetting(minValue=0.0, maxValue=2.0, useSlider=true)
    private double growthScaleModifier = 1.0;
    private boolean allowPlanting = true;
    private boolean cloningMachineEnabled = true;
    @ConfigSetting(minValue=0.0)
    private int lakeTrioMaxEnchants = 3;
    private boolean engagePlayerByPokeBall = true;
    private boolean enableWildAggression = true;
    private EnumEncounterMode shrineEncounterMode = EnumEncounterMode.Once;
    private boolean spawnersOpOnly = true;
    private boolean npcEditorOpOnly = true;
    private boolean questEditorOpOnly = true;
    private boolean tradersReusable = false;
    private int movesPerTutor = 20;
    private boolean useSystemTimeForWorldTime = false;
    private int timeUpdateInterval = 30;
    private boolean allowPokemonEditors = true;
    private boolean allowChisels = true;
    @ConfigSetting(minValue=1.0)
    private int maxLevel = 100;
    private boolean canPokemonBeHit = false;
    private boolean alwaysHaveMegaRing = false;
    private boolean alwaysHaveDynamaxBand = false;
    private int chanceToGetSpecialBidoof = 30;
    private boolean disabledNonPlayerMovement = false;
    private String fallbackCaptureMethod = "gen8";
    private boolean allowShinyCharmFromPokedex = true;
    private boolean allowOvalCharmFromPokedex = true;
    private double expCharmMultiplier = 1.5;
    private double catchingCharmMultiplier = 1.1;
    private int markCharmRolls = 3;
    @ConfigSetting(minValue=1.0)
    private int hammerDurabilityLossMultiplier = 3;
    private Map<String, OreColor> oreColors = new HashMap<String, OreColor>(){
        {
            this.put("0", new OreColor("minecraft:coal_ore", Integer.parseInt("E2C0AA", 16), 0));
            this.put("1", new OreColor("minecraft:iron_ore", Integer.parseInt("E2C0AA", 16), 0));
            this.put("2", new OreColor("minecraft:gold_ore", Integer.parseInt("FCEE4B", 16), 0));
            this.put("3", new OreColor("minecraft:redstone_ore", Integer.parseInt("FF0000", 16), 0));
            this.put("4", new OreColor("minecraft:emerald_ore", Integer.parseInt("17DD62", 16), 0));
            this.put("5", new OreColor("minecraft:diamond_ore", Integer.parseInt("65F5E3", 16), 0));
            this.put("6", new OreColor("minecraft:lapis_ore", Integer.parseInt("1855BD", 16), 2));
            this.put("7", new OreColor("minecraft:quartz_ore", Integer.parseInt("EAE5DE", 16), 3));
            this.put("8", new OreColor("pixelmon:amethyst_ore", Integer.parseInt("9543A9", 16), 4));
            this.put("9", new OreColor("pixelmon:sun_stone_ore", Integer.parseInt("E57742", 16), 5));
            this.put("10", new OreColor("pixelmon:silicon_ore", Integer.parseInt("E2DFEE", 16), 0));
            this.put("11", new OreColor("pixelmon:sapphire_ore", Integer.parseInt("4A73E7", 16), 1));
            this.put("12", new OreColor("pixelmon:ruby_ore", Integer.parseInt("DD1C33", 16), 1));
            this.put("13", new OreColor("pixelmon:fossil", Integer.parseInt("443D32", 16), 6));
            this.put("14", new OreColor("pixelmon:crystal_ore", Integer.parseInt("AFEEEE", 16), 4));
            this.put("15", new OreColor("pixelmon:bauxite_ore", Integer.parseInt("D1B584", 16), 0));
            this.put("16", new OreColor("pixelmon:dawn_dusk_ore", Integer.parseInt("000000", 16), 7));
            this.put("17", new OreColor("pixelmon:water_stone_ore", Integer.parseInt("5D719F", 16), 8));
            this.put("18", new OreColor("pixelmon:thunder_stone_ore", Integer.parseInt("F0FF01", 16), 9));
            this.put("19", new OreColor("pixelmon:leaf_stone_ore", Integer.parseInt("7EA167", 16), 10));
            this.put("20", new OreColor("pixelmon:fire_stone_ore", Integer.parseInt("CC7132", 16), 11));
        }
    };
    private int averageLureExpiryTicks = 17920;
    private boolean limitShopKeeperStackSize = true;
    private List<String> oldGenDimensions = Lists.newArrayList();
    private List<String> bothGenDimensions = Lists.newArrayList((Object[])new String[]{"pixelmon:ultra_space", "pixelmon:drowned", "minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
    private float dynamaxSize = 15.0f;
    private boolean allowIllegalShinies = true;
    private boolean berryJuiceCrafting = true;
    private boolean pokeGiftReusable = false;
    private int elevatorSearchRange = 10;
    private boolean starterOnJoin = true;
    private boolean useDiscordRichPresence = !JavaHelper.isAndroid();
    private Debug debug = new Debug();
    private TMHM tms = new TMHM();
    private Drops drops = new Drops();
    private Healing healing = new Healing();
    private AFKHandler afkHandler = new AFKHandler();
    private Pokerus pokerus = new Pokerus();
    private Riding riding = new Riding();
    private OutsideEffects outsideEffects = new OutsideEffects();

    public int getHammerDurabilityLossMultiplier() {
        return this.hammerDurabilityLossMultiplier;
    }

    public void setHammerDurabilityLossMultiplier(int hammerDurabilityLossMultiplier) {
        this.hammerDurabilityLossMultiplier = hammerDurabilityLossMultiplier;
    }

    public double getStartingBalance() {
        return this.startingBalance;
    }

    public boolean isAwardTokens() {
        return this.awardTokens;
    }

    public boolean isAllowPokemonNicknames() {
        return this.allowPokemonNicknames;
    }

    public boolean isAllowVanillaMobs() {
        return this.allowVanillaMobs;
    }

    public boolean isAllowCaptureOutsideBattle() {
        return this.allowCaptureOutsideBattle;
    }

    public boolean isAllowRandomPokemonToBeLegendary() {
        return this.allowRandomPokemonToBeLegendary;
    }

    public double getGrowthScaleModifier() {
        return this.growthScaleModifier;
    }

    public boolean isAllowPlanting() {
        return this.allowPlanting;
    }

    public boolean isCloningMachineEnabled() {
        return this.cloningMachineEnabled;
    }

    public int getLakeTrioMaxEnchants() {
        return this.lakeTrioMaxEnchants;
    }

    public boolean isEngagePlayerByPokeBall() {
        return this.engagePlayerByPokeBall;
    }

    public boolean isEnableWildAggression() {
        return this.enableWildAggression;
    }

    public EnumEncounterMode getShrineEncounterMode() {
        return this.shrineEncounterMode;
    }

    public boolean isSpawnersOpOnly() {
        return this.spawnersOpOnly;
    }

    public boolean isNpcEditorOpOnly() {
        return this.npcEditorOpOnly;
    }

    public boolean isQuestEditorOpOnly() {
        return this.questEditorOpOnly;
    }

    public boolean isTradersReusable() {
        return this.tradersReusable;
    }

    public int getMovesPerTutor() {
        return this.movesPerTutor;
    }

    public boolean isUseSystemTimeForWorldTime() {
        return this.useSystemTimeForWorldTime;
    }

    public int getTimeUpdateInterval() {
        return this.timeUpdateInterval;
    }

    public boolean isAllowPokemonEditors() {
        return this.allowPokemonEditors;
    }

    public boolean isAllowChisels() {
        return this.allowChisels;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean isCanPokemonBeHit() {
        return this.canPokemonBeHit;
    }

    public boolean isAlwaysHaveMegaRing() {
        return this.alwaysHaveMegaRing;
    }

    public boolean isAlwaysHaveDynamaxBand() {
        return this.alwaysHaveDynamaxBand;
    }

    public int getChanceToGetSpecialBidoof() {
        return this.chanceToGetSpecialBidoof;
    }

    public boolean isDisabledNonPlayerMovement() {
        return this.disabledNonPlayerMovement;
    }

    public boolean isAllowShinyCharmFromPokedex() {
        return this.allowShinyCharmFromPokedex;
    }

    public boolean isAllowOvalCharmFromPokedex() {
        return this.allowOvalCharmFromPokedex;
    }

    public double getExpCharmMultiplier() {
        return this.expCharmMultiplier;
    }

    public double getCatchingCharmMultiplier() {
        return this.catchingCharmMultiplier;
    }

    public int getMarkCharmRolls() {
        return this.markCharmRolls;
    }

    public List<OreColor> getOreColors() {
        return Lists.newArrayList(this.oreColors.values());
    }

    public OreColor getEntryForBlock(String registryName) {
        for (OreColor value : this.oreColors.values()) {
            if (!value.getBlockId().equalsIgnoreCase(registryName)) continue;
            return value;
        }
        return null;
    }

    public int getAverageLureExpiryTicks() {
        return this.averageLureExpiryTicks;
    }

    public boolean isLimitShopKeeperStackSize() {
        return this.limitShopKeeperStackSize;
    }

    public int getShopMaxStackSize(ItemStack stack) {
        if (this.isLimitShopKeeperStackSize()) {
            return stack == null ? 64 : stack.func_77976_d();
        }
        return 2304;
    }

    public List<String> getOldGenDimensions() {
        return this.oldGenDimensions;
    }

    public List<String> getBothGenDimensions() {
        return this.bothGenDimensions;
    }

    public float getDynamaxSize() {
        return this.dynamaxSize;
    }

    public boolean isAllowIllegalShinies() {
        return this.allowIllegalShinies;
    }

    public boolean isBerryJuiceCrafting() {
        return this.berryJuiceCrafting;
    }

    public boolean isPokeGiftReusable() {
        return this.pokeGiftReusable;
    }

    public int getElevatorSearchRange() {
        return this.elevatorSearchRange;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public TMHM getTMs() {
        return this.tms;
    }

    public Drops getDrops() {
        return this.drops;
    }

    public Healing getHealing() {
        return this.healing;
    }

    public AFKHandler getAfkHandler() {
        return this.afkHandler;
    }

    public Pokerus getPokerus() {
        return this.pokerus;
    }

    public Riding getRiding() {
        return this.riding;
    }

    public OutsideEffects getOutsideEffects() {
        return this.outsideEffects;
    }

    public boolean usesGen8Features(RegistryKey<World> dimension) {
        return this.getBothGenDimensions().contains(dimension.func_240901_a_().toString()) || !this.getOldGenDimensions().contains(dimension.func_240901_a_().toString());
    }

    public boolean isStarterOnJoin() {
        return this.starterOnJoin;
    }

    public String getFallbackCaptureMethod() {
        return this.fallbackCaptureMethod;
    }

    public boolean isUseDiscordRichPresence() {
        return this.useDiscordRichPresence;
    }

    @ConfigSerializable
    public static class OreColor {
        private String blockId;
        private int color;
        private int pattern;

        public OreColor(String blockId, int color, int pattern) {
            this.blockId = blockId;
            this.color = color;
            this.pattern = pattern;
        }

        public OreColor() {
        }

        public String getBlockId() {
            return this.blockId;
        }

        public int getColor() {
            return this.color;
        }

        public int getPattern() {
            return this.pattern;
        }
    }

    @ConfigSerializable
    public static class Healing {
        private boolean bedsHealPokemon = true;
        private boolean usePassiveHealer = true;
        private float chanceToRevivePassively = 0.001f;
        private float chanceToHealStatusPassively = 0.005f;
        private int stepsToHealHealthPassively = 75;
        private float passiveHealingMaxHealthPercentage = 0.25f;

        public boolean isBedsHealPokemon() {
            return this.bedsHealPokemon;
        }

        public boolean isUsePassiveHealer() {
            return this.usePassiveHealer;
        }

        public float getChanceToRevivePassively() {
            return this.chanceToRevivePassively;
        }

        public float getChanceToHealStatusPassively() {
            return this.chanceToHealStatusPassively;
        }

        public int getStepsToHealHealthPassively() {
            return this.stepsToHealHealthPassively;
        }

        public float getPassiveHealingMaxHealthPercentage() {
            return this.passiveHealingMaxHealthPercentage;
        }
    }

    @ConfigSerializable
    public static class TMHM {
        private boolean allowTMReuse = true;
        private boolean allowTRReuse = true;
        private boolean universalTMs = true;
        private boolean superUniversalTMs = false;

        public boolean isAllowTMReuse() {
            return this.allowTMReuse;
        }

        public boolean isAllowTRReuse() {
            return this.allowTRReuse;
        }

        public boolean isUniversalTMs() {
            return this.universalTMs;
        }

        public boolean isSuperUniversalTMs() {
            return this.superUniversalTMs;
        }
    }

    @ConfigSerializable
    public static class Drops {
        private boolean pokemonDropsEnabled = true;
        private boolean useDropGUI = true;
        private boolean deleteUnwantedDrops = false;
        private List<Integer> denStarDrops = Arrays.asList(2, 4, 6, 8, 10);

        public boolean isPokemonDropsEnabled() {
            return this.pokemonDropsEnabled;
        }

        public boolean isUseDropGUI() {
            return this.useDropGUI;
        }

        public boolean isDeleteUnwantedDrops() {
            return this.deleteUnwantedDrops;
        }

        public List<Integer> getDenStarDrops() {
            return this.denStarDrops;
        }
    }

    @ConfigSerializable
    public static class Debug {
        private boolean printErrors = true;
        private boolean useUpdateEntityWithOptionalForceFix = false;
        private boolean verbose = false;

        public boolean isPrintErrors() {
            return this.printErrors;
        }

        public boolean isUseUpdateEntityWithOptionalForceFix() {
            return this.useUpdateEntityWithOptionalForceFix;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }

    @ConfigSerializable
    public static class AFKHandler {
        private boolean enabled = false;
        private int afkActivateSeconds = 90;
        private int afkTimerTurnSeconds = 15;

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getAfkActivateSeconds() {
            return this.afkActivateSeconds;
        }

        public int getAfkTimerTurnSeconds() {
            return this.afkTimerTurnSeconds;
        }
    }

    @ConfigSerializable
    public static class Pokerus {
        private boolean enabled = true;
        private float spawnRate = 12288.0f;
        private boolean informPlayers = true;
        private int spreadRate = 5;

        public boolean shouldCatchPokerus() {
            if (!this.enabled || this.getSpawnRate() <= 0.0f) {
                return false;
            }
            return RandomHelper.getRandomChance(1.0f / this.spawnRate);
        }

        @Deprecated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Deprecated
        public float getSpawnRate() {
            return this.spawnRate;
        }

        public boolean isInformPlayers() {
            return this.informPlayers;
        }

        public int getSpreadRate() {
            return this.spreadRate;
        }
    }

    @ConfigSerializable
    public static class Riding {
        private boolean allowRiding = true;
        private float ridingSpeedMultiplier = 1.0f;
        private boolean enablePointToSteer = true;
        private boolean landMount = true;
        private boolean requireHM = false;
        private float flyingSpeedLimit = 4.0f;

        public boolean isAllowRiding() {
            return this.allowRiding;
        }

        public float getRidingSpeedMultiplier() {
            return this.ridingSpeedMultiplier;
        }

        public boolean isEnablePointToSteer() {
            return this.enablePointToSteer;
        }

        public boolean isLandMount() {
            return this.landMount;
        }

        public boolean isRequireHM() {
            return this.requireHM;
        }

        public float getFlyingSpeedLimit() {
            return this.flyingSpeedLimit;
        }
    }

    @ConfigSerializable
    public static class OutsideEffects {
        private boolean useOutsideEffects = true;
        private int stepsToApplyEffects = 15;
        private int poisonMaxDamage = 5;

        public boolean isUseOutsideEffects() {
            return this.useOutsideEffects;
        }

        public int getStepsToApplyEffects() {
            return this.stepsToApplyEffects;
        }

        public int getPoisonMaxDamage() {
            return this.poisonMaxDamage;
        }
    }
}

