/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.command;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.command.impl.wiki.DayCareStrategy;
import com.pixelmonmod.pixelmon.command.impl.wiki.EvolutionStrategy;
import com.pixelmonmod.pixelmon.command.impl.wiki.FormsPaletteStrategy;
import com.pixelmonmod.pixelmon.command.impl.wiki.MainStrategy;
import com.pixelmonmod.pixelmon.command.impl.wiki.MovesStrategy;
import com.pixelmonmod.pixelmon.command.impl.wiki.SpawningStrategy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.CommandSource;

public class WikiCommandStrategyLoader {
    private static List<WikiCommandStrategy> strategies;
    private static WikiCommandStrategy defaultStrategy;

    public static void executeStrategy(CommandSource sender, Pokemon pokemon, String[] specs, String strategyId) {
        WikiCommandStrategy strategy = WikiCommandStrategyLoader.getStrategy(strategyId).orElse(defaultStrategy);
        strategy.execute(sender, pokemon, specs);
    }

    public static Optional<WikiCommandStrategy> getStrategy(String strategyId) {
        return WikiCommandStrategyLoader.getOrLoadStrategies().stream().filter(it -> it.matches(strategyId)).findFirst();
    }

    public static void registerStrategy(WikiCommandStrategy strategy) {
        if (WikiCommandStrategyLoader.getOrLoadStrategies().stream().anyMatch(s -> strategy.ids.stream().anyMatch(s::matches))) {
            Pixelmon.LOGGER.error("A WikiCommandStrategy already exist matching (any of) the Ids! Unable to register");
            return;
        }
        strategies.add(strategy);
    }

    public static void unregisterStrategy(WikiCommandStrategy strategy) {
        strategies.remove(strategy);
    }

    public static List<WikiCommandStrategy> getStrategies() {
        return WikiCommandStrategyLoader.getOrLoadStrategies();
    }

    public static List<WikiCommandStrategy> getStrategiesPrioritized() {
        ArrayList<WikiCommandStrategy> strategies = new ArrayList<WikiCommandStrategy>(WikiCommandStrategyLoader.getStrategies());
        strategies.sort(Comparator.comparing(WikiCommandStrategy::getPriority).reversed());
        return strategies;
    }

    private static List<WikiCommandStrategy> getOrLoadStrategies() {
        if (strategies == null) {
            defaultStrategy = new MainStrategy();
            strategies = new ArrayList<WikiCommandStrategy>();
            strategies.add(defaultStrategy);
            strategies.add(new DayCareStrategy());
            strategies.add(new SpawningStrategy());
            strategies.add(new FormsPaletteStrategy());
            strategies.add(new MovesStrategy());
            strategies.add(new EvolutionStrategy());
        }
        return strategies;
    }
}

