/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.TimeHandler;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.effects.PassiveEffectProxy;
import com.pixelmonmod.pixelmon.api.pokemon.hatch.EggHatcherProxy;
import com.pixelmonmod.pixelmon.api.pokemon.healing.PassiveHealingProxy;
import com.pixelmonmod.pixelmon.api.pokemon.lure.LureExpiringProxy;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.starter.ChooseStarterScreen;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.GuiOpenClosePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.StarterListPacket;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TickHandler {
    boolean screenOpen = false;
    boolean initialised = false;
    public int worldCounter;
    private int ticksSincePlayersCheck = 0;
    private static final List<ServerPlayerEntity> playerListForStartMenu = Lists.newCopyOnWriteArrayList();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side != LogicalSide.SERVER) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.player;
        if (player.field_71104_cf != null) {
            FishingBobberEntity hook = player.field_71104_cf;
            if (hook.field_146043_c instanceof DenEntity) {
                hook.field_146043_c = null;
            }
        }
        if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
            player.func_242279_ag();
        }
        PlayerPartyStorage pps = StorageProxy.getParty(player);
        EggHatcherProxy.tick(player, pps);
        PassiveHealingProxy.tick(player, pps);
        PassiveEffectProxy.tick(player, pps);
        LureExpiringProxy.tick(player, pps, pps.getLureStack());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (ServerStorageDisplay.showStarterScreen && Minecraft.func_71410_x().field_71462_r == null) {
            try {
                if (ClientStorageManager.party != null && ClientStorageManager.party.countAll() > 0) {
                    ServerStorageDisplay.showStarterScreen = false;
                } else {
                    Minecraft.func_71410_x().func_147108_a((Screen)new ChooseStarterScreen());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!(Minecraft.func_71410_x().field_71462_r == null || this.screenOpen && this.initialised || Minecraft.func_71410_x().field_71462_r instanceof ChatScreen)) {
            NetworkHelper.sendToServer(new GuiOpenClosePacket(true));
            this.screenOpen = true;
            this.initialised = true;
        } else if (this.screenOpen && Minecraft.func_71410_x().field_71462_r == null || !this.initialised) {
            NetworkHelper.sendToServer(new GuiOpenClosePacket(false));
            this.screenOpen = false;
            this.initialised = true;
            if (Minecraft.func_71410_x().field_71474_y.field_74319_N || !ForgeIngameGui.renderHotbar) {
                Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
                ForgeIngameGui.renderHotbar = true;
                ForgeIngameGui.renderCrosshairs = true;
                ForgeIngameGui.renderExperiance = true;
                ForgeIngameGui.renderAir = true;
                ForgeIngameGui.renderHealth = true;
                ForgeIngameGui.renderFood = true;
                ForgeIngameGui.renderArmor = true;
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Scheduling.tick();
            return;
        }
        if (this.worldCounter % (PixelmonConfigProxy.getGeneral().getTimeUpdateInterval() * 20) == 0) {
            TimeHandler.changeTime();
        }
        if (!playerListForStartMenu.isEmpty() && this.worldCounter % 100 == 0) {
            for (ServerPlayerEntity player : playerListForStartMenu) {
                NetworkHelper.sendPacket(player, new StarterListPacket());
            }
        }
        if (++this.ticksSincePlayersCheck >= 20) {
            this.ticksSincePlayersCheck = 0;
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                StorageProxy.getParty(player).checkPokerus();
            }
        }
        ++this.worldCounter;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            WorldTime.getCurrent(event.world);
            EvolutionQueryList.tick(event.world);
            LearnMoveController.tick(event.world);
        }
    }

    public static void registerStarterList(ServerPlayerEntity player) {
        if (playerListForStartMenu.contains(player)) {
            return;
        }
        NetworkHelper.sendPacket(player, new StarterListPacket());
        ServerPlayerEntity listEntry = null;
        for (ServerPlayerEntity listPlayer : playerListForStartMenu) {
            if (!listPlayer.func_110124_au().equals(player.func_110124_au())) continue;
            listEntry = listPlayer;
            break;
        }
        if (listEntry == null) {
            playerListForStartMenu.add(player);
        }
    }

    public static void deregisterStarterList(ServerPlayerEntity player) {
        ServerPlayerEntity listEntry = null;
        for (ServerPlayerEntity listPlayer : playerListForStartMenu) {
            if (!listPlayer.func_110124_au().equals(player.func_110124_au())) continue;
            listEntry = listPlayer;
            break;
        }
        playerListForStartMenu.remove(listEntry);
    }

    @SubscribeEvent
    public void onPlayerJoinedServer(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            PlayerExtraDataStore.sendDisplayPacket();
        }
    }
}

