/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.pixelmonmod.api.requirement.AbstractRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractStringRequirement<A, B>
extends AbstractRequirement<A, B, String> {
    protected String value;
    protected String defaultValue;

    public AbstractStringRequirement(Set<String> keys, String defaultValue) {
        super(keys);
        this.defaultValue = defaultValue;
    }

    public AbstractStringRequirement(Set<String> keys, String defaultValue, String value) {
        this(keys, defaultValue);
        this.value = value;
    }

    @Override
    public List<Requirement<A, B, ?>> createSimple(String key, String spec) {
        if (spec.startsWith(key + ":")) {
            String[] args = spec.split(key + ":");
            String value = args.length > 0 ? args[1] : this.defaultValue;
            return Collections.singletonList(this.createInstance(value));
        }
        return Collections.emptyList();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

