/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MoveRequirement
implements Requirement<Pokemon, PixelmonEntity, Pair<Integer, ImmutableAttack>> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"move"});
    private int pos;
    private ImmutableAttack attack;

    public MoveRequirement() {
    }

    public MoveRequirement(int pos, ImmutableAttack attack) {
        this.pos = pos;
        this.attack = attack;
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList(KEYS);
    }

    public MoveRequirement(Pair<Integer, ImmutableAttack> data) {
        this((Integer)data.getFirst(), (ImmutableAttack)data.getSecond());
    }

    @Override
    public boolean fits(String spec) {
        for (String key : KEYS) {
            if (!spec.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> create(String spec) {
        for (String key : KEYS) {
            String[] afterKey;
            if (!spec.contains(key) || (afterKey = StringHelper.findValuesAfterKeyBeforeSpace(spec, key)) == null) continue;
            ArrayList requirements = Lists.newArrayList();
            for (String data : afterKey) {
                String[] args = data.split(":");
                int pos = NumberHelper.parseInt(args[0]).orElse(-1);
                if (pos > 4 || pos < 1) {
                    pos = -1;
                }
                if (!AttackRegistry.getAttackBase(args[1].replace("_", " ")).isPresent()) continue;
                requirements.add(this.createInstance((Pair<Integer, ImmutableAttack>)Pair.of((Object)pos, AttackRegistry.getAttackBase(args[1].replace("_", " ")).orElse(null))));
            }
            return requirements;
        }
        return Collections.emptyList();
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Pair<Integer, ImmutableAttack>> createInstance(Pair<Integer, ImmutableAttack> value) {
        return new MoveRequirement(value);
    }

    @Override
    public boolean isMinecraftMatch(PixelmonEntity entity) {
        return this.isDataMatch(entity.getPokemon());
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        Moveset moveset = pixelmon.getMoveset();
        if (this.pos > 0 && this.pos < 5) {
            int index = this.pos - 1;
            if (moveset.get(index) != null) {
                return moveset.get(index).isAttack(this.attack);
            }
            return false;
        }
        return moveset.hasAttack(this.attack);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (pixelmon.getForm() == null) {
            pixelmon.setForm(pixelmon.getSpecies().getDefaultForm());
        }
        if (pixelmon.getMoveset() == null) {
            pixelmon.rerollMoveset();
        }
        if (this.pos > 0 && this.pos < 5) {
            int moveslot = this.pos - 1;
            pixelmon.getMoveset().set(moveslot, this.attack.ofMutable());
        } else {
            pixelmon.getMoveset().add(this.attack.ofMutable());
        }
    }

    @Override
    public void applyMinecraft(PixelmonEntity entity) {
        this.applyData(entity.getPokemon());
    }

    @Override
    public Pair<Integer, ImmutableAttack> getValue() {
        return Pair.of((Object)this.pos, (Object)this.attack);
    }
}

