/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class HeldItemRequirement
extends AbstractPokemonRequirement<HeldItem> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"helditem", "hi"});
    private HeldItem heldItem;

    public HeldItemRequirement() {
        super(KEYS);
    }

    public HeldItemRequirement(HeldItem heldItem) {
        this();
        this.heldItem = heldItem;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0 || args.length == 1) {
            return Collections.emptyList();
        }
        String rs = "pixelmon:" + args[1];
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(rs));
        if (item == null) {
            return Collections.emptyList();
        }
        if (!(item instanceof HeldItem)) {
            return Collections.emptyList();
        }
        HeldItem heldItem = (HeldItem)item;
        return Collections.singletonList(this.createInstance(heldItem));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, HeldItem> createInstance(HeldItem value) {
        return new HeldItemRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals((Object)this.heldItem, pixelmon.getHeldItem().func_77973_b());
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setHeldItem(new ItemStack((IItemProvider)this.heldItem.getItem()));
    }

    @Override
    public HeldItem getValue() {
        return this.heldItem;
    }
}

