/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon;

import com.pixelmonmod.api.AbstractSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.World;

public class PokemonSpecification
extends AbstractSpecification<Pokemon, PixelmonEntity> {
    public PokemonSpecification(String originalSpec, List<Requirement<Pokemon, PixelmonEntity, ?>> requirements) {
        super(Pokemon.class, PixelmonEntity.class, originalSpec, requirements);
    }

    public PokemonSpecification clone() {
        return PokemonSpecificationProxy.create(this.originalSpec);
    }

    @Override
    public Pokemon create() {
        return this.create(false);
    }

    @Override
    public Pokemon create(boolean shallow) {
        Pokemon pokemon = PokemonFactory.create(UUID.randomUUID());
        for (Requirement requirement : this.requirements) {
            requirement.applyData(pokemon);
        }
        if (this.requirements.isEmpty()) {
            pokemon.setSpecies(PixelmonSpecies.MISSINGNO.getValueUnsafe(), true);
        }
        if (!shallow) {
            pokemon.initialize(InitializeCategory.EMPTY);
        }
        return pokemon;
    }

    public PixelmonEntity create(World world) {
        PixelmonEntity entity = new PixelmonEntity(world, this.create());
        for (Requirement requirement : this.requirements) {
            requirement.applyMinecraft(entity);
        }
        return entity;
    }
}

